/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

class TabPaneSelectionModelImpl
extends SingleSelectionModel<Tab> {
    private ClickOnSelectedTabListener clickOnSelectedTabListener;
    private final TabPane tabPane;

    public void setClickOnSelectedTabListener(ClickOnSelectedTabListener clickOnSelectedTabListener) {
        this.clickOnSelectedTabListener = clickOnSelectedTabListener;
    }

    public TabPaneSelectionModelImpl(TabPane t) {
        this.tabPane = Objects.requireNonNull(t);
    }

    public void select(int index) {
        if (index < 0 || this.getItemCount() > 0 && index >= this.getItemCount() || index == this.getSelectedIndex() && this.getModelItem(index).isSelected()) {
            if (Objects.nonNull(this.clickOnSelectedTabListener)) {
                this.clickOnSelectedTabListener.clickOnSelectedTab(this.getModelItem(index));
            }
            return;
        }
        this.setSelected(false);
        this.setSelectedIndex(index);
        Tab tab = this.getModelItem(index);
        if (tab != null) {
            this.setSelectedItem(tab);
        }
        this.setSelected(true);
        this.tabPane.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
    }

    private void setSelected(boolean selected) {
        if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.tabPane.getTabs().size()) {
            Tab tab = (Tab)this.tabPane.getTabs().get(this.getSelectedIndex());
            this.setSelected(tab, selected);
        }
    }

    public void select(Tab tab) {
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            Tab value = this.getModelItem(i);
            if (value == null || !value.equals(tab)) continue;
            this.select(i);
            return;
        }
        if (tab != null) {
            this.setSelectedItem(tab);
        }
    }

    private void setSelected(Tab newTab, boolean selected) {
        try {
            Method m = newTab.getClass().getDeclaredMethod("setSelected", Boolean.TYPE);
            m.setAccessible(true);
            m.invoke((Object)newTab, selected);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Exception while access Tab\u00e4setSelected with Reflection, should never happen", ex);
        }
    }

    protected Tab getModelItem(int index) {
        ObservableList items = this.tabPane.getTabs();
        if (items == null) {
            return null;
        }
        if (index < 0 || index >= items.size()) {
            return null;
        }
        return (Tab)items.get(index);
    }

    protected int getItemCount() {
        ObservableList items = this.tabPane.getTabs();
        return items == null ? 0 : items.size();
    }

    static interface ClickOnSelectedTabListener {
        public void clickOnSelectedTab(Tab var1);
    }
}

