/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.BatteryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import rst.domotic.unit.dal.BatteryDataType;

public class BatteryPane
extends AbstractUnitPane<BatteryRemote, BatteryDataType.BatteryData> {
    public BatteryPane() {
        super(BatteryRemote.class, false);
        this.setIcon((GlyphIcons)MaterialDesignIcon.BATTERY_OUTLINE, (GlyphIcons)MaterialDesignIcon.BATTERY);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        try {
            double level = ((BatteryDataType.BatteryData)((BatteryRemote)this.getUnitRemote()).getData()).getBatteryState().getLevel();
            MaterialDesignIcon icon = level > 90.0 ? MaterialDesignIcon.BATTERY : (level > 80.0 ? MaterialDesignIcon.BATTERY_90 : (level > 70.0 ? MaterialDesignIcon.BATTERY_80 : (level > 60.0 ? MaterialDesignIcon.BATTERY_70 : (level > 50.0 ? MaterialDesignIcon.BATTERY_60 : (level > 40.0 ? MaterialDesignIcon.BATTERY_50 : (level > 30.0 ? MaterialDesignIcon.BATTERY_40 : (level > 20.0 ? MaterialDesignIcon.BATTERY_30 : (level > 10.0 ? MaterialDesignIcon.BATTERY_20 : (level > 5.0 ? MaterialDesignIcon.BATTERY_10 : MaterialDesignIcon.BATTERY_ALERT)))))))));
            this.getIcon().setBackgroundIcon((Object)icon);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        try {
            switch (((BatteryDataType.BatteryData)((BatteryRemote)this.getUnitRemote()).getData()).getBatteryState().getValue()) {
                case UNKNOWN: {
                    this.getIcon().setBackgroundIconColor(Color.BLACK);
                    break;
                }
                case OK: {
                    this.getIcon().setBackgroundIconColor(Color.GREEN);
                    break;
                }
                case CRITICAL: {
                    this.getIcon().setBackgroundIconColor(Color.ORANGE);
                    this.getIcon().startBackgroundIconColorFadeAnimation(-1);
                    break;
                }
                case INSUFFICIENT: {
                    this.getIcon().setBackgroundIconColor(Color.RED);
                    this.getIcon().startBackgroundIconColorFadeAnimation(-1);
                    break;
                }
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.ERROR);
            this.getIcon().setBackgroundIconColor(Color.BLACK);
        }
    }
}

