/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.Future;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.generic.ColorChooser;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.ColorableLightRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rst.processing.TimestampJavaTimeTransform;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.openbase.jul.visual.javafx.transform.JFXColorToHSBColorTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.ColorableLightDataType;
import rst.timing.TimestampType;
import rst.vision.HSBColorType;

public class ColorableLightPane
extends AbstractUnitPane<ColorableLightRemote, ColorableLightDataType.ColorableLightData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorableLightPane.class);
    private ColorChooser colorChooser;
    private final RecurrenceEventFilter<Color> recurrenceEventFilterHSV = new RecurrenceEventFilter<Color>(300L){

        public void relay() {
            try {
                ((ColorableLightRemote)ColorableLightPane.this.getUnitRemote()).setColor(JFXColorToHSBColorTransformer.transform((Color)((Color)this.getLatestValue())));
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not send color update!", (Throwable)ex, (Logger)LOGGER);
            }
        }
    };
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);

    public ColorableLightPane() {
        super(ColorableLightRemote.class, true);
        this.setIcon((GlyphIcons)MaterialDesignIcon.LIGHTBULB_OUTLINE, (GlyphIcons)MaterialDesignIcon.LIGHTBULB);
    }

    @Override
    protected void initBodyContent(Pane bodyPane) throws CouldNotPerformException {
        this.colorChooser = new ColorChooser();
        this.colorChooser.initContent();
        this.colorChooser.selectedColorProperty().addListener((observable, old, new_value) -> {
            if (this.isHover()) {
                try {
                    this.recurrenceEventFilterHSV.trigger((Object)this.colorChooser.getSelectedColor());
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not trigger color change!", (Throwable)ex, (Logger)LOGGER);
                }
            }
        });
        bodyPane.getChildren().add((Object)this.colorChooser);
    }

    @Override
    public void updateDynamicContent() {
        Color color;
        super.updateDynamicContent();
        PowerStateType.PowerState.State state = PowerStateType.PowerState.State.UNKNOWN;
        try {
            state = ((ColorableLightDataType.ColorableLightData)((ColorableLightRemote)this.getUnitRemote()).getData()).getPowerState().getValue();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        try {
            color = JFXColorToHSBColorTransformer.transform((HSBColorType.HSBColor)((ColorableLightDataType.ColorableLightData)this.getData()).getColorState().getColor().getHsbColor());
        }
        catch (CouldNotPerformException ex) {
            color = Constants.LIGHTBULB_OFF_COLOR;
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        if (this.colorChooser != null && this.expansionProperty().get()) {
            this.colorChooser.setSelectedColor(color);
        }
        switch (state) {
            case OFF: {
                this.getIcon().setBackgroundIconColor(Constants.LIGHTBULB_OFF_COLOR);
                this.setInfoText("lightOff");
                this.setPrimaryActivationWithoutNotification(Boolean.FALSE);
                break;
            }
            case ON: {
                this.getIcon().setBackgroundIconColor(color);
                this.setInfoText("lightOn");
                this.setPrimaryActivationWithoutNotification(Boolean.TRUE);
                break;
            }
            default: {
                this.getIcon().setBackgroundIconColor(Color.TRANSPARENT);
                this.setInfoText("unknown");
            }
        }
    }

    @Override
    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return activation ? ((ColorableLightRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.ON) : ((ColorableLightRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.OFF);
    }

    @Override
    public SVGGlyphIcon getIconSymbol() {
        return new SVGGlyphIcon(MaterialDesignIcon.LIGHTBULB, 32.0, false);
    }

    @Override
    public String getUnitStateDescription() throws NotAvailableException {
        return ((ColorableLightRemote)this.getUnitRemote()).getLabel() + " was switched " + StringProcessor.transformUpperCaseToCamelCase((String)((ColorableLightDataType.ColorableLightData)this.getData()).getPowerState().getValue().name()) + " at " + this.dateFormat.format(new Date(TimestampJavaTimeTransform.transform((TimestampType.Timestamp)((ColorableLightDataType.ColorableLightData)this.getData()).getPowerState().getTimestamp()))) + " with Action[" + ((ColorableLightDataType.ColorableLightData)this.getData()).getPowerState().getResponsibleAction().getDescription() + "]";
    }
}

