/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import java.util.concurrent.TimeUnit;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.bcozy.view.pane.unit.UnitPaneFactory;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.processing.StringProcessor;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public class UnitPaneFactoryImpl
implements UnitPaneFactory {
    private static UnitPaneFactory instance;

    private UnitPaneFactoryImpl() {
    }

    public static synchronized UnitPaneFactory getInstance() {
        if (instance == null) {
            instance = new UnitPaneFactoryImpl();
        }
        return instance;
    }

    public static Class<? extends AbstractUnitPane> loadUnitPaneClass(UnitConfigType.UnitConfig config) throws CouldNotPerformException {
        return UnitPaneFactoryImpl.loadUnitPaneClass(config.getType());
    }

    public static Class<? extends AbstractUnitPane> loadUnitPaneClass(UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        try {
            String remoteClassName = null;
            if (UnitConfigProcessor.isBaseUnit((UnitTemplateType.UnitTemplate.UnitType)unitType)) {
                remoteClassName = AbstractUnitPane.class.getPackage().getName() + "." + unitType.name().toLowerCase().replaceAll("_", "") + "." + StringProcessor.transformUpperCaseToCamelCase((String)unitType.name()) + "Pane";
            } else if (UnitConfigProcessor.isDalUnit((UnitTemplateType.UnitTemplate.UnitType)unitType)) {
                remoteClassName = AbstractUnitPane.class.getPackage().getName() + "." + StringProcessor.transformUpperCaseToCamelCase((String)unitType.name()) + "Pane";
            } else {
                throw new EnumNotSupportedException((Enum)unitType, UnitPaneFactoryImpl.class);
            }
            return UnitPaneFactoryImpl.class.getClassLoader().loadClass(remoteClassName);
        }
        catch (ClassNotFoundException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not detect unit pane class for UnitType[" + unitType.name() + "]!", ex);
        }
    }

    @Override
    public AbstractUnitPane newInstance(UnitConfigType.UnitConfig config) throws InstantiationException {
        try {
            return this.newInstance(UnitPaneFactoryImpl.loadUnitPaneClass(config));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)"Could not create unit pane!", (Throwable)ex);
        }
    }

    @Override
    public <R extends AbstractUnitPane> R newInstance(Class<R> unitPaneClass) throws InstantiationException {
        try {
            return (R)((Object)((AbstractUnitPane)((Object)unitPaneClass.newInstance())));
        }
        catch (IllegalAccessException | java.lang.InstantiationException ex) {
            throw new InstantiationException((Object)("Could not instantiate unit pane out of Class[" + unitPaneClass.getName() + "]"), (Throwable)ex);
        }
    }

    @Override
    public AbstractUnitPane newInstance(UnitTemplateType.UnitTemplate.UnitType type) throws InstantiationException {
        try {
            return this.newInstance(UnitPaneFactoryImpl.loadUnitPaneClass(type));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)"Could not create unit pane!", (Throwable)ex);
        }
    }

    @Override
    public AbstractUnitPane newInstance(String unitId, long timeout, TimeUnit timeUnit) throws InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigById(unitId));
    }

    @Override
    public AbstractUnitPane newInstance(ScopeType.Scope scope, long timeout, TimeUnit timeUnit) throws InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigByScope(scope));
    }

    @Override
    public AbstractUnitPane newInitializedInstance(UnitConfigType.UnitConfig config) throws InitializationException, InstantiationException, InterruptedException {
        AbstractUnitPane unitPane = this.newInstance(config);
        unitPane.init(config);
        return unitPane;
    }

    @Override
    public AbstractUnitPane newInitializedInstance(ScopeType.Scope scope, UnitTemplateType.UnitTemplate.UnitType type) throws InitializationException, InstantiationException, InterruptedException {
        AbstractUnitPane unitPane = this.newInstance(type);
        unitPane.init(scope);
        return unitPane;
    }

    @Override
    public <R extends AbstractUnitPane> R newInitializedInstance(ScopeType.Scope scope, Class<R> unitPaneClass) throws InitializationException, InstantiationException, InterruptedException {
        R unitPane = this.newInstance(unitPaneClass);
        ((AbstractUnitPane)((Object)unitPane)).init(scope);
        return unitPane;
    }

    @Override
    public AbstractUnitPane newInitializedInstance(ScopeType.Scope scope, long timeout, TimeUnit timeUnit) throws InitializationException, InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInitializedInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigByScope(scope));
    }

    @Override
    public AbstractUnitPane newInitializedInstance(String unitId, long timeout, TimeUnit timeUnit) throws InitializationException, InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInitializedInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigById(unitId));
    }
}

