/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit.agent;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.Future;
import javafx.beans.value.ChangeListener;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.generic.EmphasisAdjustment;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.agent.AgentRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.slf4j.Logger;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.EmphasisStateType;
import rst.domotic.unit.agent.AgentDataType;

public class AgentPane
extends AbstractUnitPane<AgentRemote, AgentDataType.AgentData> {
    private EmphasisAdjustment emphasisAdjustment;
    private final RecurrenceEventFilter<EmphasisStateType.EmphasisState> recurrenceEventFilterComfort = new RecurrenceEventFilter<EmphasisStateType.EmphasisState>(300L){

        public void relay() {
            try {
                ((AgentRemote)AgentPane.this.getUnitRemote()).setEmphasisState((EmphasisStateType.EmphasisState)this.getLastValue());
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not send color update!", (Throwable)ex, (Logger)AgentPane.this.LOGGER);
            }
        }
    };

    public AgentPane() {
        super(AgentRemote.class, true);
        this.getIcon().setForegroundIcon((Object)MaterialDesignIcon.POWER);
    }

    @Override
    protected void initBodyContent(Pane bodyPane) throws CouldNotPerformException {
        this.emphasisAdjustment = new EmphasisAdjustment();
        this.emphasisAdjustment.initContent();
        ChangeListener changeListener = (observable, oldValue, newValue) -> {
            if (this.isHover()) {
                try {
                    this.recurrenceEventFilterComfort.trigger((Object)this.emphasisAdjustment.getCurrentEmphasisState());
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not trigger emphasis change!", (Throwable)ex, (Logger)this.LOGGER);
                }
            }
        };
        this.emphasisAdjustment.getComfortProperty().addListener(changeListener);
        this.emphasisAdjustment.getEnergyProperty().addListener(changeListener);
        this.emphasisAdjustment.getSecurityProperty().addListener(changeListener);
        bodyPane.getChildren().add((Object)this.emphasisAdjustment);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        ActivationStateType.ActivationState.State state = ActivationStateType.ActivationState.State.UNKNOWN;
        try {
            state = ((AgentDataType.AgentData)((AgentRemote)this.getUnitRemote()).getData()).getActivationState().getValue();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        switch (state) {
            case ACTIVE: {
                this.getIcon().setForegroundIconColor(Color.GREEN);
                this.setPrimaryActivationWithoutNotification(Boolean.TRUE);
                break;
            }
            case DEACTIVE: {
                this.getIcon().setForegroundIconColor(Color.BLACK);
                this.setPrimaryActivationWithoutNotification(Boolean.FALSE);
            }
        }
        if (this.emphasisAdjustment != null && this.expansionProperty().get()) {
            try {
                this.emphasisAdjustment.setSelectedEmphasis(((AgentDataType.AgentData)this.getData()).getEmphasisState());
            }
            catch (NotAvailableException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
            }
        }
    }

    @Override
    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return activation ? ((AgentRemote)this.getUnitRemote()).setActivationState(ActivationStateType.ActivationState.State.ACTIVE) : ((AgentRemote)this.getUnitRemote()).setActivationState(ActivationStateType.ActivationState.State.DEACTIVE);
    }
}

