/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javax.vecmath.Point3d;
import org.openbase.bco.bcozy.view.SimpleUnitSymbolsPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.bcozy.view.pane.unit.TitledUnitPaneContainer;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.geometry.PoseType;

public class MaintenanceLayerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaintenanceLayerController.class);
    private final LocationPane locationPane;
    private final SimpleUnitSymbolsPane simpleUnitSymbolsPane;
    private final Map<String, TitledUnitPaneContainer> titledPaneMap;

    public MaintenanceLayerController(SimpleUnitSymbolsPane unitPane, LocationPane locationPane) {
        this.locationPane = locationPane;
        this.simpleUnitSymbolsPane = unitPane;
        this.titledPaneMap = new HashMap<String, TitledUnitPaneContainer>();
        unitPane.scaleXProperty().bind((ObservableValue)locationPane.scaleXProperty());
        unitPane.scaleYProperty().bind((ObservableValue)locationPane.scaleYProperty());
        unitPane.translateXProperty().bind((ObservableValue)locationPane.translateXProperty());
        unitPane.translateYProperty().bind((ObservableValue)locationPane.translateYProperty());
    }

    public void connectUnitRemote() throws CouldNotPerformException, InterruptedException {
        try {
            Registries.getUnitRegistry((boolean)false).addDataObserver((source, data) -> Platform.runLater(() -> this.updateUnits()));
            this.updateUnits();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not fetch units from remote registry", (Throwable)ex);
        }
    }

    public void updateUnits() {
        Platform.runLater(() -> {
            try {
                this.fetchLocationUnitRemotes();
                this.simpleUnitSymbolsPane.updateUnitsPane();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not update all units!", (Throwable)ex, (Logger)LOGGER);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        });
    }

    public void fetchLocationUnitRemotes() throws CouldNotPerformException, InterruptedException {
        this.simpleUnitSymbolsPane.clearUnits();
        double halfButtonSize = 26.0;
        List locationUnitConfigList = Registries.getLocationRegistry().getLocationConfigs();
        for (UnitConfigType.UnitConfig locationConfig : locationUnitConfigList) {
            if (locationConfig.getPlacementConfig().getShape().getFloorCount() == 0) continue;
            for (Map.Entry nextEntry : ((LocationRemote)Units.getUnit((String)locationConfig.getId(), (boolean)false, (Class)Units.LOCATION)).getUnitMap().entrySet()) {
                if (((List)nextEntry.getValue()).isEmpty()) continue;
                for (UnitRemote unit : (List)nextEntry.getValue()) {
                    UnitConfigType.UnitConfig config;
                    if (!(nextEntry.getKey() == UnitTemplateType.UnitTemplate.UnitType.BATTERY | nextEntry.getKey() == UnitTemplateType.UnitTemplate.UnitType.TAMPER_DETECTOR | nextEntry.getKey() == UnitTemplateType.UnitTemplate.UnitType.TEMPERATURE_SENSOR | nextEntry.getKey() == UnitTemplateType.UnitTemplate.UnitType.SMOKE_DETECTOR) || (config = (UnitConfigType.UnitConfig)unit.getConfig()).getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED || !config.getPlacementConfig().hasPosition()) continue;
                    PoseType.Pose pose = config.getPlacementConfig().getPosition();
                    try {
                        Future transform = Registries.getLocationRegistry().getUnitTransformationFuture(config, Registries.getLocationRegistry().getRootLocationConfig());
                        Point3d unitVertex = new Point3d(0.0, 0.0, 1.0);
                        ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(unitVertex);
                        Point2D coord = new Point2D(unitVertex.x * 50.0, unitVertex.y * 50.0);
                        this.simpleUnitSymbolsPane.addUnit((UnitRemote<? extends GeneratedMessage>)unit, coord.add(-13.0, -26.0), locationConfig.getId());
                    }
                    catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
                        if (JPService.verboseMode()) {
                            ExceptionPrinter.printHistory((String)("Could not fetch " + unit + "!"), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.WARN);
                            continue;
                        }
                        ExceptionPrinter.printHistory((String)("Could not fetch " + unit + "!"), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
                    }
                }
            }
        }
    }
}

