/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.StackPane;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.SimpleUnitSymbolsPane;
import org.openbase.bco.bcozy.view.UnitSymbolsPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;

public class BackgroundPane
extends StackPane {
    private final LocationPane locationPane;
    private final UnitSymbolsPane unitSymbolsPane;
    private final SimpleUnitSymbolsPane editingLayerPane;
    private final SimpleUnitSymbolsPane maintenanceLayerPane;

    public BackgroundPane(ForegroundPane foregroundPane) throws InstantiationException, InterruptedException {
        try {
            this.locationPane = new LocationPane(foregroundPane);
            this.getChildren().add((Object)this.locationPane);
            this.unitSymbolsPane = new UnitSymbolsPane();
            this.unitSymbolsPane.setPickOnBounds(false);
            this.getChildren().add((Object)this.unitSymbolsPane);
            this.unitSymbolsPane.selectedLocationId.bind((ObservableValue)this.locationPane.selectedLocationId);
            this.maintenanceLayerPane = new SimpleUnitSymbolsPane();
            this.maintenanceLayerPane.setPickOnBounds(false);
            this.editingLayerPane = new SimpleUnitSymbolsPane();
            this.editingLayerPane.setPickOnBounds(false);
            foregroundPane.getAppState().addListener((observable, oldValue, newValue) -> {
                switch (newValue) {
                    case SETTINGS: {
                        this.getChildren().clear();
                        this.getChildren().add((Object)this.locationPane);
                        this.getChildren().add((Object)this.editingLayerPane);
                        break;
                    }
                    case TEMPERATURE: {
                        this.getChildren().clear();
                        this.getChildren().add((Object)this.locationPane);
                        this.getChildren().add((Object)this.maintenanceLayerPane);
                        break;
                    }
                    case MOVEMENT: {
                        this.getChildren().clear();
                        this.getChildren().add((Object)this.locationPane);
                        this.getChildren().add((Object)this.unitSymbolsPane);
                    }
                }
            });
            this.getStyleClass().add((Object)"background-pane");
            this.locationPane.initMultiTouch();
            this.onMouseClickedProperty().bindBidirectional((Property)this.locationPane.onMouseClickedProperty());
            this.onMouseEnteredProperty().bindBidirectional((Property)this.locationPane.onMouseEnteredProperty());
            this.onMouseExitedProperty().bindBidirectional((Property)this.locationPane.onMouseExitedProperty());
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public UnitSymbolsPane getUnitsPane() {
        return this.unitSymbolsPane;
    }

    public SimpleUnitSymbolsPane getMaintenancePane() {
        return this.maintenanceLayerPane;
    }

    public SimpleUnitSymbolsPane getEditingPane() {
        return this.editingLayerPane;
    }

    public LocationPane getLocationPane() {
        return this.locationPane;
    }
}

