/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.BoundingBox;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.openbase.bco.bcozy.controller.CenterPaneController;
import org.openbase.bco.bcozy.view.CenterPane;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.MainMenu;
import org.openbase.bco.bcozy.view.MenuHeader;
import org.openbase.bco.bcozy.view.UnitMenu;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.iface.DefaultInitializable;

public class ForegroundPane
extends BorderPane
implements DefaultInitializable {
    private final MainMenu mainMenu;
    private final UnitMenu unitMenu;
    private final CenterPane centerPane;
    private final MenuHeader menuHeader;
    private final InfoPane infoFooter;
    private final ObjectProperty<CenterPaneController.State> appState;

    public ForegroundPane(double height, double width) throws InstantiationException {
        try {
            this.mainMenu = new MainMenu(height - 150.0, 300.0);
            this.unitMenu = new UnitMenu(height - 150.0, 300.0);
            this.unitMenu.getFullscreen().setOnAction(event -> this.setMaximizeAction());
            this.unitMenu.getSettingsBtn().setOnAction(event -> this.toggleSettings());
            this.menuHeader = new MenuHeader(30.0, width);
            this.infoFooter = new InfoPane(20.0, width);
            this.centerPane = new CenterPane(height - 150.0, this);
            this.setLeft((Node)this.mainMenu);
            this.setRight((Node)this.unitMenu);
            this.setBottom((Node)this.infoFooter);
            this.setCenter((Node)this.centerPane);
            this.setTop((Node)this.menuHeader);
            this.setPickOnBounds(false);
            this.appState = new SimpleObjectProperty((Object)CenterPaneController.State.MOVEMENT);
            this.appState.bind(this.centerPane.appStateProperty);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public ObjectProperty<CenterPaneController.State> getAppState() {
        return this.appState;
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            this.mainMenu.init();
        }
        catch (CouldNotPerformException ex) {
            new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public UnitMenu getUnitMenu() {
        return this.unitMenu;
    }

    public CenterPane getCenterPane() {
        return this.centerPane;
    }

    public InfoPane getInfoFooter() {
        return this.infoFooter;
    }

    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.mainMenu.getLayoutBounds().getMaxX(), this.menuHeader.getLayoutBounds().getMaxY(), this.centerPane.getWidth(), this.centerPane.getHeight());
    }

    public ReadOnlyDoubleProperty getMainMenuWidthProperty() {
        return this.mainMenu.widthProperty();
    }

    private void setMaximizeAction() {
        Stage stage = (Stage)this.unitMenu.getScene().getWindow();
        if (stage.isFullScreen()) {
            this.unitMenu.getFullscreen().changeIcon((GlyphIcons)MaterialIcon.FULLSCREEN);
            stage.setFullScreen(false);
        } else {
            this.unitMenu.getFullscreen().changeIcon((GlyphIcons)MaterialIcon.FULLSCREEN_EXIT);
            stage.setFullScreen(true);
        }
    }

    private void toggleSettings() {
        if (this.centerPane.getChildren().contains((Object)this.centerPane.getSettingsMenu())) {
            this.centerPane.getChildren().remove((Object)this.centerPane.getSettingsMenu());
        } else {
            this.centerPane.getChildren().add(0, (Object)this.centerPane.getSettingsMenu());
            this.centerPane.getSettingsMenu().toFront();
        }
    }
}

