/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;

public final class ImageViewProvider {
    private static List<ImageView> imageViews = new ArrayList<ImageView>();
    private static ColorAdjust colorEffect = new ColorAdjust(1.0, 1.0, -1.0, 0.0);

    private ImageViewProvider() {
    }

    public static ImageView createImageView(double size, String imageURI) throws CouldNotPerformException {
        return ImageViewProvider.createImageView(size, size, imageURI);
    }

    public static ImageView createImageView(double width, double height, String imageURI) throws CouldNotPerformException {
        Image icon = new Image(ImageViewProvider.class.getResourceAsStream(imageURI));
        ImageView imageView = new ImageView(icon);
        imageView.setPreserveRatio(true);
        imageView.setFitHeight(height);
        imageView.setFitWidth(width);
        return ImageViewProvider.registerImageView(imageView);
    }

    public static List<ImageView> createImageView(double width, double height, String ... imageURI) throws CouldNotPerformException {
        ArrayList<ImageView> imageViewList = new ArrayList<ImageView>(imageURI.length);
        for (String uri : imageURI) {
            imageViewList.add(ImageViewProvider.createImageView(width, height, uri));
        }
        return imageViewList;
    }

    public static ImageView registerImageView(ImageView imageView) throws CouldNotPerformException {
        if (imageView == null) {
            throw new NotAvailableException("imageView");
        }
        imageView.setSmooth(true);
        imageView.setEffect((Effect)colorEffect);
        imageViews.add(imageView);
        return imageView;
    }

    public static void colorizeIconsToWhite() {
        ImageViewProvider.colorizeIcons(1.0, 1.0, 1.0, 0.0);
    }

    public static void colorizeIconsToBlack() {
        ImageViewProvider.colorizeIcons(1.0, 1.0, -1.0, 0.0);
    }

    public static void colorizeIcons(double hue, double saturation, double brightness, double contrast) {
        colorEffect = new ColorAdjust(hue, saturation, brightness, contrast);
        for (ImageView imageView : imageViews) {
            imageView.setEffect((Effect)colorEffect);
            imageView.setSmooth(true);
        }
    }

    public static ColorAdjust getColorEffect() {
        return colorEffect;
    }
}

