/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.generic;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.openbase.jul.visual.javafx.iface.DynamicPane;

public class ColorChooser
extends HBox
implements DynamicPane {
    public static final double ROUND_ANGLE = 360.0;
    public static final int OBTUSE_ANGLE_270 = 270;
    public static final int RIGHT_ANGLE = 90;
    public static final int RGB255 = 255;
    private static final double COLOR_BOX_SIZE = 75.0;
    private final ObjectProperty<Color> selectedColorProperty;
    private final DoubleProperty hueProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty saturationProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty brightnessProperty = new SimpleDoubleProperty(0.0);
    private final Rectangle hueValueSelector = new Rectangle();
    private double rectX;
    private double rectY;
    private double angle;

    public ColorChooser() {
        this.selectedColorProperty = new SimpleObjectProperty((Object)Color.BLACK);
    }

    static double clamp(double value) {
        return value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
    }

    public void initContent() {
        StackPane colorRectContainer = new StackPane();
        Pane colorHue = new Pane();
        Circle circle = this.circleSelector();
        Shape hollowCircle = this.hollowCircle();
        Rectangle clip = new Rectangle(0.0, 0.0, 0.0, 0.0);
        Pane colorCircleContainer = new Pane();
        this.minWidth(75.0);
        this.minHeight(75.0);
        colorCircleContainer.setPrefSize(75.0, 75.0);
        colorCircleContainer.setMinSize(75.0, 75.0);
        colorCircleContainer.maxHeightProperty().bind((ObservableValue)colorCircleContainer.prefWidthProperty());
        colorHue.setMinSize(75.0, 75.0);
        colorHue.setPrefSize(75.0, 75.0);
        colorHue.backgroundProperty().bind((ObservableValue)new ObjectBinding<Background>(){
            {
                this.bind(new Observable[]{ColorChooser.this.hueProperty});
            }

            protected Background computeValue() {
                return new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.hsb((double)ColorChooser.this.hueProperty.getValue(), (double)1.0, (double)1.0), CornerRadii.EMPTY, Insets.EMPTY)});
            }
        });
        circle.layoutXProperty().bind((ObservableValue)this.saturationProperty.multiply(75.0));
        circle.layoutYProperty().bind((ObservableValue)Bindings.subtract((int)1, (ObservableNumberValue)this.brightnessProperty).multiply(75.0));
        EventHandler colorContainerMouseHandler = event -> {
            double xMouse = event.getX();
            double yMouse = event.getY();
            this.saturationProperty.set(ColorChooser.clamp(xMouse / 75.0));
            this.brightnessProperty.set(1.0 - ColorChooser.clamp(yMouse / 75.0));
            this.updateColor();
            event.consume();
        };
        EventHandler colorContainerTouchHandler = event -> event.consume();
        colorRectContainer.setMinSize(75.0, 75.0);
        colorRectContainer.setPrefSize(75.0, 75.0);
        colorRectContainer.maxHeightProperty().bind((ObservableValue)colorRectContainer.prefWidthProperty());
        colorRectContainer.getChildren().addAll((Object[])new Node[]{colorHue, this.saturationRect(), this.brightnessRect(), circle});
        colorRectContainer.setOnMousePressed(colorContainerMouseHandler);
        colorRectContainer.setOnMouseDragged(colorContainerMouseHandler);
        this.setOnTouchMoved(colorContainerTouchHandler);
        this.setOnTouchPressed(colorContainerTouchHandler);
        this.setOnTouchReleased(colorContainerTouchHandler);
        this.hueValueSelector.setWidth(7.5);
        this.hueValueSelector.setHeight(12.5);
        this.hueValueSelector.setFill((Paint)Color.web((String)"white", (double)0.0));
        this.hueValueSelector.getStyleClass().add((Object)"rectangle-selector");
        this.hueValueSelector.setMouseTransparent(true);
        this.hueValueSelector.setTranslateX(-this.hueValueSelector.getWidth() / 2.0);
        this.hueValueSelector.setTranslateY(-this.hueValueSelector.getHeight() / 2.0);
        this.hueValueSelector.setLayoutX(37.5);
        this.hueValueSelector.setLayoutY(37.5);
        this.hueValueSelector.setY((this.hueValueSelector.getHeight() - 75.0) / 2.0);
        this.hueValueSelector.setStroke((Paint)Color.web((String)"white", (double)1.0));
        this.hueValueSelector.setCache(true);
        this.hueValueSelector.setManaged(false);
        this.hueValueSelector.setEffect((Effect)this.dropShadow());
        EventHandler colorCircleMouseHandler = event -> {
            double yMouse = event.getY();
            double xMouse = event.getX();
            this.angle = (Math.toDegrees(Math.atan2(yMouse, xMouse)) + 360.0 + 90.0) % 360.0;
            this.hueProperty.set(this.angle);
            this.rectSelectorCoordinates();
            this.hueValueSelector.setLayoutX(this.rectX);
            this.hueValueSelector.setLayoutY(this.rectY);
            this.hueValueSelector.setRotate(this.angle);
            this.updateColor();
            event.consume();
        };
        hollowCircle.setOnMousePressed(colorCircleMouseHandler);
        hollowCircle.setOnMouseDragged(colorCircleMouseHandler);
        colorCircleContainer.getChildren().addAll((Object[])new Node[]{hollowCircle, this.hueValueSelector});
        this.getChildren().addAll((Object[])new Node[]{colorRectContainer, colorCircleContainer});
        this.prefHeightProperty().set(85.0);
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clip);
        this.initEffectAndSwitch();
    }

    private void initEffectAndSwitch() {
        this.hueValueSelector.setY(0.0);
        this.rectSelectorCoordinates();
        this.hueValueSelector.setLayoutX(this.rectX);
        this.hueValueSelector.setLayoutY(this.rectY);
        this.hueValueSelector.setRotate(this.angle);
    }

    public void updateColor() {
        this.selectedColorProperty.setValue((Object)Color.hsb((double)this.hueProperty.get(), (double)this.saturationProperty.get(), (double)this.brightnessProperty.get()));
    }

    public void updateDynamicContent() {
        this.hueProperty.set(((Color)this.selectedColorProperty.get()).getHue());
        this.angle = ((Color)this.selectedColorProperty.get()).getHue();
    }

    public ObjectProperty<Color> selectedColorProperty() {
        return this.selectedColorProperty;
    }

    private Image colorSpectrumImage(int width, int height, Stop ... stops) {
        WritableImage writableImage = new WritableImage(width, height);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        Color color = Color.TRANSPARENT;
        Point2D center = new Point2D((double)width / 2.0, (double)height / 2.0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double deltaX = (double)x - center.getX();
                double deltaY = (double)y - center.getY();
                double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                double angle = Math.abs(Math.toDegrees(Math.acos(deltaX / distance)));
                if (deltaX >= 0.0 && deltaY <= 0.0) {
                    angle = 90.0 - angle;
                } else if (deltaX >= 0.0 && deltaY >= 0.0) {
                    angle += 90.0;
                } else if (deltaX <= 0.0 && deltaY >= 0.0) {
                    angle += 90.0;
                } else if (deltaX <= 0.0 && deltaY <= 0.0) {
                    angle = 450.0 - angle;
                }
                for (int i = 0; i < stops.length - 1; ++i) {
                    double offset = stops[i].getOffset();
                    double nextOffset = stops[i + 1].getOffset();
                    if (!(angle >= offset * 360.0) || !(angle < nextOffset * 360.0)) continue;
                    double fraction = (angle - offset * 360.0) / ((nextOffset - offset) * 360.0);
                    color = this.interpolateColor(stops[i].getColor(), stops[i + 1].getColor(), fraction);
                }
                pixelWriter.setColor(x, y, color);
            }
        }
        return writableImage;
    }

    private Color interpolateColor(Color colorOne, Color colorTwo, double fraction) {
        double red = colorOne.getRed() + (colorTwo.getRed() - colorOne.getRed()) * fraction;
        double green = colorOne.getGreen() + (colorTwo.getGreen() - colorOne.getGreen()) * fraction;
        double blue = colorOne.getBlue() + (colorTwo.getBlue() - colorOne.getBlue()) * fraction;
        double opacity = colorOne.getOpacity() + (colorTwo.getOpacity() - colorOne.getOpacity()) * fraction;
        red = ColorChooser.clamp(red);
        green = ColorChooser.clamp(green);
        blue = ColorChooser.clamp(blue);
        opacity = ColorChooser.clamp(opacity);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }

    private Stop[] hueStops() {
        Stop[] stops = new Stop[255];
        for (int i = 0; i < 255; ++i) {
            double offset = 0.00392156862745098 * (double)i;
            int hue = (int)((double)((float)i / 255.0f) * 360.0);
            stops[i] = new Stop(offset, Color.hsb((double)hue, (double)1.0, (double)1.0));
        }
        return stops;
    }

    private Circle circleSelector() {
        Circle circle = new Circle(5.0, (Paint)Color.web((String)"white", (double)0.0));
        circle.getStyleClass().add((Object)"circle-selector");
        circle.setMouseTransparent(true);
        circle.setStroke((Paint)Color.web((String)"white", (double)1.0));
        circle.setCache(true);
        circle.setManaged(false);
        circle.setEffect((Effect)this.dropShadow());
        return circle;
    }

    private DropShadow dropShadow() {
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(1.0);
        dropShadow.setOffsetY(1.0);
        dropShadow.setColor(Color.BLACK);
        return dropShadow;
    }

    public Color getSelectedColor() {
        return (Color)this.selectedColorProperty.get();
    }

    public void setSelectedColor(Color color) {
        if (!this.isHover()) {
            this.hueProperty.set(color.getHue());
            this.angle = color.getHue();
        }
    }

    private Pane saturationRect() {
        Pane colorRectSaturation = new Pane();
        colorRectSaturation.setPrefSize(75.0, 75.0);
        colorRectSaturation.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)1.0)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.0))}), CornerRadii.EMPTY, Insets.EMPTY)}));
        return colorRectSaturation;
    }

    private Pane brightnessRect() {
        Pane colorRectBrightness = new Pane();
        colorRectBrightness.setPrefSize(75.0, 75.0);
        colorRectBrightness.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0, (double)0.0)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)1.0))}), CornerRadii.EMPTY, Insets.EMPTY)}));
        return colorRectBrightness;
    }

    private Shape hollowCircle() {
        Circle circleTall = new Circle(37.5);
        Circle circleSmall = new Circle(circleTall.getRadius() - 12.5);
        Shape hollowCircle = Path.subtract((Shape)circleTall, (Shape)circleSmall);
        Stop[] hueFraction = this.hueStops();
        ImagePattern imagePattern = new ImagePattern(this.colorSpectrumImage(75, 75, hueFraction));
        hollowCircle.setLayoutX(circleTall.getRadius());
        hollowCircle.setLayoutY(circleTall.getRadius());
        hollowCircle.setFill((Paint)imagePattern);
        return hollowCircle;
    }

    private void rectSelectorCoordinates() {
        this.rectX = Math.round(37.5 + (75.0 - this.hueValueSelector.getHeight()) / 2.0 * Math.cos(Math.toRadians((this.angle + 270.0) % 360.0)));
        this.rectY = Math.round(37.5 + (75.0 - this.hueValueSelector.getHeight()) / 2.0 * Math.sin(Math.toRadians((this.angle + 270.0) % 360.0)));
    }
}

