/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.generic;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import org.openbase.bco.bcozy.view.generic.WidgetPane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;

public class ExpandableWidgedPane
extends WidgetPane {
    private final Pane bodyPane;
    private final Timeline timeline;
    private final boolean initialExpanded;
    private final ChangeListener<Boolean> dynamicContentChangeObserver;
    protected final BooleanProperty expansionProperty;
    private boolean startup = true;
    double bodyHeight;

    public ExpandableWidgedPane(boolean initialExpanded, boolean activateable) {
        super(activateable);
        this.initialExpanded = initialExpanded;
        this.bodyPane = new HBox();
        this.dynamicContentChangeObserver = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> paramObservableValue, Boolean paramT1, Boolean expaneded) {
                try {
                    ExpandableWidgedPane.this.updateDynamicContent();
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((String)("Could not update all dynamic components of " + (Object)((Object)ExpandableWidgedPane.this)), (Throwable)ex, (Logger)ExpandableWidgedPane.this.LOGGER);
                }
            }
        };
        this.timeline = new Timeline();
        this.expansionProperty = new SimpleBooleanProperty(false);
    }

    @Override
    public void initContent() {
        super.initContent();
        this.bodyPane.getStyleClass().clear();
        this.bodyPane.getStyleClass().addAll((Object[])new String[]{"body-pane"});
        try {
            this.initBodyContent(this.bodyPane);
        }
        catch (RuntimeException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not init body content of " + (Object)((Object)this)), (Throwable)ex, (Logger)this.LOGGER);
        }
        this.initBodyPaneAnimation(this.bodyPane);
        this.prefHeightProperty().bind((ObservableValue)this.headPane.prefHeightProperty().add((ObservableNumberValue)this.bodyPane.prefHeightProperty()));
        this.getChildren().add((Object)this.bodyPane);
        this.expansionProperty.bindBidirectional((Property)this.secondaryActivationProperty());
        this.expansionProperty.removeListener(this.dynamicContentChangeObserver);
        this.expansionProperty.addListener(this.dynamicContentChangeObserver);
        this.expansionProperty.set(this.initialExpanded);
        this.disableProperty().addListener((observable, oldValue, disabled) -> {
            if (disabled.booleanValue()) {
                this.expansionProperty.set(false);
            }
        });
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        boolean expanded = this.expansionProperty.get();
        this.bodyPane.setManaged(expanded);
        this.bodyPane.setVisible(expanded);
    }

    private void animate(boolean expanded) {
        Timeline timelineTest = new Timeline();
        if (expanded) {
            KeyFrame closed = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.bodyPane.prefHeightProperty(), (Object)0)});
            KeyFrame open = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.bodyPane.prefHeightProperty(), (Object)230)});
            timelineTest.getKeyFrames().addAll((Object[])new KeyFrame[]{closed, open});
        } else {
            KeyFrame open = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.bodyPane.prefHeightProperty(), (Object)230)});
            KeyFrame closed = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.bodyPane.prefHeightProperty(), (Object)0)});
            timelineTest.getKeyFrames().addAll((Object[])new KeyFrame[]{open, closed});
        }
        timelineTest.play();
    }

    protected void initBodyContent(Pane bodyPane) throws CouldNotPerformException {
    }

    private void initBodyPaneAnimation(Pane bodyPane) {
        this.timeline.setAutoReverse(true);
        KeyValue open = new KeyValue((WritableValue)bodyPane.prefHeightProperty(), (Object)-1);
        KeyValue closed = new KeyValue((WritableValue)bodyPane.prefHeightProperty(), (Object)0);
        KeyFrame openCloseKeyFrame = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{closed, open});
        this.timeline.getKeyFrames().add((Object)openCloseKeyFrame);
    }

    public BooleanProperty expansionProperty() {
        return this.expansionProperty;
    }
}

