/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.generic;

import javafx.scene.Node;
import javafx.scene.input.TouchPoint;
import javafx.scene.layout.Pane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;

public abstract class MultiTouchPane
extends Pane {
    private double prevTouchCordX;
    private double prevTouchCordY;
    private double prevMouseCordX;
    private double prevMouseCordY;
    private Integer touchPointId;
    private boolean multiTouchEnabled = true;

    public MultiTouchPane() {
    }

    public MultiTouchPane(Node ... children) {
        super(children);
    }

    public void initMultiTouch() throws CouldNotPerformException {
        try {
            this.getParent().setOnMousePressed(event -> {
                if (event.isSynthesized()) {
                    return;
                }
                this.prevMouseCordX = event.getX();
                this.prevMouseCordY = event.getY();
                event.consume();
            });
            this.getParent().setOnMouseDragged(event -> {
                if (event.isSynthesized()) {
                    return;
                }
                this.setTranslateX(this.getTranslateX() + (event.getX() - this.prevMouseCordX));
                this.setTranslateY(this.getTranslateY() + (event.getY() - this.prevMouseCordY));
                this.prevMouseCordX = event.getX();
                this.prevMouseCordY = event.getY();
                event.consume();
            });
            this.getParent().setOnScroll(event -> {
                if (event.isDirect()) {
                    return;
                }
                if (event.isInertia()) {
                    return;
                }
                if (event.getDeltaY() == 0.0) {
                    return;
                }
                double scaleFactor = event.getDeltaY() > 0.0 ? 1.05 : 0.9523809523809523;
                this.setScaleX(this.getScaleX() * scaleFactor);
                this.setScaleY(this.getScaleY() * scaleFactor);
                this.setTranslateX(this.getTranslateX() * scaleFactor);
                this.setTranslateY(this.getTranslateY() * scaleFactor);
                event.consume();
            });
            this.getParent().setOnTouchPressed(event -> {
                if (this.isTouchMovementInProcess()) {
                    return;
                }
                this.touchPointId = event.getTouchPoint().getId();
                this.prevTouchCordX = event.getTouchPoint().getSceneX();
                this.prevTouchCordY = event.getTouchPoint().getSceneY();
                event.consume();
            });
            if (this.getParent() == null) {
                throw new NotAvailableException("Parent Node of " + ((Object)((Object)this)).getClass().getSimpleName());
            }
            this.getParent().setOnTouchMoved(event -> {
                if (!this.isCurrentTouchPoint(event.getTouchPoint())) {
                    return;
                }
                if (this.multiTouchEnabled ? event.getTouchCount() != 2 : event.getTouchCount() != 1) {
                    return;
                }
                this.setTranslateX(this.getTranslateX() + (event.getTouchPoint().getSceneX() - this.prevTouchCordX));
                this.setTranslateY(this.getTranslateY() + (event.getTouchPoint().getSceneY() - this.prevTouchCordY));
                this.prevTouchCordX = event.getTouchPoint().getX();
                this.prevTouchCordY = event.getTouchPoint().getY();
                event.consume();
            });
            this.getParent().setOnTouchReleased(event -> {
                if (!this.isTouchMovementInProcess()) {
                    return;
                }
                if (event.getTouchPoint().getId() != this.touchPointId.intValue()) {
                    return;
                }
                this.touchPointId = null;
                event.consume();
            });
            this.getParent().setOnZoom(event -> {
                if (event.isInertia()) {
                    return;
                }
                this.setScaleX(this.getScaleX() * event.getZoomFactor());
                this.setScaleY(this.getScaleY() * event.getZoomFactor());
                this.setTranslateX(this.getTranslateX() * event.getZoomFactor());
                this.setTranslateY(this.getTranslateY() * event.getZoomFactor());
                event.consume();
            });
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not initialize Multitouch!", (Throwable)ex);
        }
    }

    private boolean isCurrentTouchPoint(TouchPoint touchPoint) {
        return this.isTouchMovementInProcess() && this.touchPointId.intValue() == touchPoint.getId();
    }

    private boolean isTouchMovementInProcess() {
        return this.touchPointId != null;
    }
}

