/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Lighting;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import javafx.util.Duration;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.generic.MultiTouchPane;
import org.openbase.bco.bcozy.view.location.ConnectionPolygon;
import org.openbase.bco.bcozy.view.location.DoorPolygon;
import org.openbase.bco.bcozy.view.location.LocationPolygon;
import org.openbase.bco.bcozy.view.location.PassagePolygon;
import org.openbase.bco.bcozy.view.location.RegionPolygon;
import org.openbase.bco.bcozy.view.location.TilePolygon;
import org.openbase.bco.bcozy.view.location.WindowPolygon;
import org.openbase.bco.bcozy.view.location.ZonePolygon;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public final class LocationPane
extends MultiTouchPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationPane.class);
    private static boolean initialized;
    public final SimpleStringProperty selectedLocationId;
    private final ForegroundPane foregroundPane;
    private final List<LocationPolygon> locationHoverLevelList;
    private final Map<String, TilePolygon> tileMap;
    private final Map<String, RegionPolygon> regionMap;
    private final Map<String, ZonePolygon> zoneMap;
    private final Map<String, ConnectionPolygon> connectionMap;
    private final List<Node> debugNodes;
    private LocationPolygon selectedLocation;
    private ZonePolygon rootLocation;
    private LocationPolygon lastClickTarget;
    private LocationPolygon lastSelectedTile;

    public LocationPane(ForegroundPane foregroundPane) throws InstantiationException, InterruptedException {
        this.foregroundPane = foregroundPane;
        this.locationHoverLevelList = new ArrayList<LocationPolygon>();
        this.tileMap = new HashMap<String, TilePolygon>();
        this.regionMap = new HashMap<String, RegionPolygon>();
        this.zoneMap = new HashMap<String, ZonePolygon>();
        this.connectionMap = new HashMap<String, ConnectionPolygon>();
        this.debugNodes = new ArrayList<Node>();
        this.selectedLocationId = new SimpleStringProperty("DUMMY");
        this.rootLocation = null;
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.setTranslateY(this.getTranslateY() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0 * this.getScaleY()));
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.setTranslateX(this.getTranslateX() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0 * this.getScaleX()));
        this.foregroundPane.getMainMenuWidthProperty().addListener((observable, oldValue, newValue) -> this.setTranslateX(this.getTranslateX() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0));
    }

    private void selectRootLocation() {
        if (this.rootLocation == null) {
            LOGGER.debug("Could not select root because its not available.");
            return;
        }
        if (this.rootLocation.equals(this.selectedLocation)) {
            return;
        }
        if (this.selectedLocation != null) {
            this.selectedLocation.setSelected(false);
        }
        this.rootLocation.setSelected(true);
        try {
            this.setSelectedLocation(this.rootLocation);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not select root loaction!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    public boolean isInitialized() {
        return initialized;
    }

    public void setInitialized(boolean init) {
        initialized = init;
    }

    public ForegroundPane getForeground() {
        return this.foregroundPane;
    }

    public void addLocation(UnitConfigType.UnitConfig locationUnitConfig, List<Point2D> vertices) throws CouldNotPerformException, InterruptedException {
        try {
            double[] points = new double[vertices.size() * 2];
            for (int i = 0; i < vertices.size(); ++i) {
                points[i * 2] = vertices.get(i).getY() * 50.0;
                points[i * 2 + 1] = vertices.get(i).getX() * 50.0;
            }
            switch (locationUnitConfig.getLocationConfig().getType()) {
                case TILE: {
                    TilePolygon tilePolygon = new TilePolygon(this, points);
                    tilePolygon.init(locationUnitConfig);
                    tilePolygon.activate();
                    this.tileMap.put(locationUnitConfig.getId(), tilePolygon);
                    break;
                }
                case REGION: {
                    RegionPolygon regionPolygon = new RegionPolygon(this, points);
                    regionPolygon.init(locationUnitConfig);
                    regionPolygon.activate();
                    this.regionMap.put(locationUnitConfig.getId(), regionPolygon);
                    break;
                }
                case ZONE: {
                    ZonePolygon zonePolygon = new ZonePolygon(this, points);
                    zonePolygon.init(locationUnitConfig);
                    zonePolygon.activate();
                    if (locationUnitConfig.getLocationConfig().getRoot()) {
                        this.setRootLocation(zonePolygon);
                    }
                    this.zoneMap.put(locationUnitConfig.getId(), zonePolygon);
                    break;
                }
                default: {
                    throw new EnumNotSupportedException((Enum)locationUnitConfig.getLocationConfig().getType(), (Object)this);
                }
            }
            if (JPService.debugMode()) {
                Circle coordinate;
                StackPane globalBaseStack = new StackPane();
                StackPane locationBaseStack = new StackPane();
                StackPane[] locationStacks = new StackPane[vertices.size()];
                this.debugNodes.clear();
                double COORDINATE_BLOCK_SIZE = 15.0;
                for (int i = 0; i < vertices.size(); ++i) {
                    Text text = new Text(Integer.toString(i));
                    text.setStroke((Paint)Color.BLACK);
                    coordinate = new Circle(15.0);
                    coordinate.setFill((Paint)Color.WHITE);
                    coordinate.setEffect((Effect)new Lighting());
                    locationStacks[i] = new StackPane();
                    locationStacks[i].getChildren().addAll((Object[])new Node[]{coordinate, text});
                    locationStacks[i].autosize();
                    locationStacks[i].setLayoutX(vertices.get(i).getY() * 50.0 - locationStacks[i].getWidth() / 2.0);
                    locationStacks[i].setLayoutY(vertices.get(i).getX() * 50.0 - locationStacks[i].getHeight() / 2.0);
                    int pos = i;
                    locationStacks[i].hoverProperty().addListener((observable, oldValue, newValue) -> InfoPane.info("This is the " + pos + ". coordinate of the " + locationUnitConfig.getLabel()));
                    this.debugNodes.add((Node)locationStacks[i]);
                }
                Text text = new Text("X");
                text.setStroke((Paint)Color.BLACK);
                coordinate = new Circle(15.0);
                coordinate.setFill((Paint)Color.CORNFLOWERBLUE);
                coordinate.setEffect((Effect)new Lighting());
                locationBaseStack.getChildren().addAll((Object[])new Node[]{coordinate, text});
                locationBaseStack.autosize();
                locationBaseStack.setLayoutX(locationUnitConfig.getPlacementConfig().getPosition().getTranslation().getY() * 50.0 - locationBaseStack.getWidth() / 2.0);
                locationBaseStack.setLayoutY(locationUnitConfig.getPlacementConfig().getPosition().getTranslation().getX() * 50.0 - locationBaseStack.getHeight() / 2.0);
                locationBaseStack.hoverProperty().addListener((observable, oldValue, newValue) -> InfoPane.info("This is the base of the " + locationUnitConfig.getLabel()));
                this.debugNodes.add((Node)locationBaseStack);
                text = new Text("O");
                text.setStroke((Paint)Color.BLACK);
                coordinate = new Circle(15.0);
                coordinate.setFill((Paint)Color.DARKRED);
                coordinate.setEffect((Effect)new Lighting());
                globalBaseStack.getChildren().addAll((Object[])new Node[]{coordinate, text});
                globalBaseStack.autosize();
                globalBaseStack.setLayoutX(0.0 - globalBaseStack.getWidth() / 2.0);
                globalBaseStack.setLayoutY(0.0 - globalBaseStack.getHeight() / 2.0);
                globalBaseStack.hoverProperty().addListener((observable, oldValue, newValue) -> InfoPane.info("This is the global base."));
                this.debugNodes.add((Node)globalBaseStack);
            }
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not add location!", (Throwable)ex);
        }
    }

    public void addConnection(UnitConfigType.UnitConfig connectionUnitConfig, List<Point2D> vertices) throws CouldNotPerformException, InterruptedException {
        try {
            ConnectionPolygon connectionPolygon;
            double[] points = new double[vertices.size() * 2];
            for (int i = 0; i < vertices.size(); ++i) {
                points[i * 2] = vertices.get(i).getY() * 50.0;
                points[i * 2 + 1] = vertices.get(i).getX() * 50.0;
            }
            switch (connectionUnitConfig.getConnectionConfig().getType()) {
                case DOOR: {
                    connectionPolygon = new DoorPolygon(points);
                    break;
                }
                case WINDOW: {
                    connectionPolygon = new WindowPolygon(points);
                    break;
                }
                case PASSAGE: {
                    connectionPolygon = new PassagePolygon(points);
                    break;
                }
                default: {
                    throw new EnumNotSupportedException((Enum)connectionUnitConfig.getConnectionConfig().getType(), (Object)this);
                }
            }
            connectionPolygon.init(connectionUnitConfig);
            connectionPolygon.activate();
            this.connectionMap.put(connectionUnitConfig.getId(), connectionPolygon);
            connectionUnitConfig.getConnectionConfig().getTileIdList().forEach(locationId -> {
                if (this.tileMap.containsKey(locationId)) {
                    this.tileMap.get(locationId).addCuttingShape((Shape)connectionPolygon);
                } else {
                    String unitLabel = locationId;
                    try {
                        unitLabel = Registries.getUnitRegistry((boolean)false).getUnitConfigById(locationId).getLabel();
                    }
                    catch (InterruptedException | CouldNotPerformException throwable) {
                        // empty catch block
                    }
                    LOGGER.debug("Location " + unitLabel + " can not be found in the location Map. No Cutting will be applied.");
                }
            });
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not add connection!", (Throwable)ex);
        }
    }

    public void clearLocations() {
        this.tileMap.forEach((locationId, locationPolygon) -> {
            locationPolygon.shutdown();
            this.getChildren().remove(locationPolygon);
        });
        this.tileMap.clear();
        this.regionMap.forEach((locationId, locationPolygon) -> {
            locationPolygon.shutdown();
            this.getChildren().remove(locationPolygon);
        });
        this.regionMap.clear();
        this.setRootLocation(null);
    }

    private synchronized void setRootLocation(ZonePolygon rootLocation) {
        if (this.rootLocation == rootLocation) {
            return;
        }
        if (this.rootLocation != null) {
            this.onMouseClickedProperty().unbind();
            this.onMouseEnteredProperty().unbind();
            this.onMouseExitedProperty().unbind();
        }
        this.rootLocation = rootLocation;
        if (this.rootLocation != null) {
            this.onMouseClickedProperty().bind((ObservableValue)rootLocation.onMouseClickedProperty());
            this.onMouseEnteredProperty().bind((ObservableValue)rootLocation.onMouseEnteredProperty());
            this.onMouseExitedProperty().bind((ObservableValue)rootLocation.onMouseExitedProperty());
        }
    }

    public void clearConnections() {
        this.connectionMap.forEach((connectionId, connectionPolygon) -> {
            connectionPolygon.shutdown();
            this.getChildren().remove(connectionPolygon);
        });
        this.connectionMap.clear();
    }

    public void updateLocationPane() {
        this.getChildren().clear();
        this.tileMap.forEach((locationId, locationPolygon) -> {
            if (this.rootLocation != null) {
                this.rootLocation.addCuttingShape((Shape)locationPolygon);
            }
            this.getChildren().add(locationPolygon);
        });
        if (this.rootLocation != null) {
            this.getChildren().add((Object)this.rootLocation);
        }
        this.regionMap.forEach((locationId, locationPolygon) -> {
            if (this.rootLocation != null) {
                this.rootLocation.addCuttingShape((Shape)locationPolygon);
            }
            this.getChildren().add(locationPolygon);
        });
        this.connectionMap.forEach((connectionId, connectionPolygon) -> {
            if (this.rootLocation != null) {
                this.rootLocation.addCuttingShape((Shape)connectionPolygon);
            }
            this.getChildren().add(connectionPolygon);
        });
        if (JPService.debugMode()) {
            for (Node debugNode : this.debugNodes) {
                this.getChildren().add((Object)debugNode);
            }
        }
        if (!this.isLocationSelected()) {
            this.selectRootLocation();
        }
    }

    private boolean isLocationSelected() {
        return this.selectedLocation != null;
    }

    public LocationPolygon getLastClickTarget() {
        return this.lastClickTarget;
    }

    void setSelectedLocation(LocationPolygon newSelectedLocation) throws CouldNotPerformException {
        try {
            this.lastClickTarget = newSelectedLocation;
            if (this.selectedLocation != null && this.selectedLocation.equals(newSelectedLocation)) {
                return;
            }
            if (this.lastSelectedTile != null && !newSelectedLocation.getClass().equals(RegionPolygon.class)) {
                this.lastSelectedTile.getChildIds().forEach(childId -> {
                    try {
                        if (this.regionMap.containsKey(childId)) {
                            this.regionMap.get(childId).changeStyleOnSelectable(false);
                        }
                    }
                    catch (Exception ex) {
                        ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                    }
                });
            }
            if (newSelectedLocation.getClass().equals(TilePolygon.class)) {
                this.lastSelectedTile = newSelectedLocation;
                newSelectedLocation.getChildIds().forEach(childId -> {
                    try {
                        this.regionMap.get(childId).changeStyleOnSelectable(true);
                    }
                    catch (Exception ex) {
                        ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                    }
                });
            }
            if (this.selectedLocation != null) {
                this.selectedLocation.setSelected(false);
            }
            newSelectedLocation.setSelected(true);
            this.selectedLocation = newSelectedLocation;
            this.selectedLocationId.set(newSelectedLocation.getUnitId());
            this.foregroundPane.getUnitMenu().getRoomInfo().setText(this.selectedLocation.getLabel());
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not select location polygon!", (Throwable)ex);
        }
    }

    public void zoomFit() {
        if (this.rootLocation != null) {
            this.autoFocusPolygon(this.rootLocation);
        } else if (!this.tileMap.isEmpty()) {
            this.autoFocusPolygon(this.tileMap.values().iterator().next());
        }
    }

    public void addSelectedLocationIdListener(ChangeListener<? super String> changeListener) {
        this.selectedLocationId.addListener(changeListener);
    }

    public void removeSelectedLocationIdListener(ChangeListener<? super String> changeListener) {
        this.selectedLocationId.removeListener(changeListener);
    }

    private void autoFocusPolygon(LocationPolygon polygon) {
        double yScale;
        double xScale = this.foregroundPane.getBoundingBox().getWidth() / polygon.prefWidth(0.0) * 0.7;
        double scale = xScale < (yScale = this.foregroundPane.getBoundingBox().getHeight() / polygon.prefHeight(0.0) * 0.7) ? xScale : yScale;
        this.setScaleX(scale);
        this.setScaleY(scale);
        Point2D transition = this.calculateTransition(scale, polygon);
        this.setTranslateX(transition.getX());
        this.setTranslateY(transition.getY());
    }

    void autoFocusPolygonAnimated(LocationPolygon polygon) {
        double yScale;
        double xScale = this.foregroundPane.getBoundingBox().getWidth() / polygon.prefWidth(0.0) * 0.7;
        double scale = xScale < (yScale = this.foregroundPane.getBoundingBox().getHeight() / polygon.prefHeight(0.0) * 0.7) ? xScale : yScale;
        ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)500.0));
        scaleTransition.setToX(scale);
        scaleTransition.setToY(scale);
        scaleTransition.setCycleCount(1);
        scaleTransition.setAutoReverse(true);
        Point2D transition = this.calculateTransition(scale, polygon);
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)500.0));
        translateTransition.setToX(transition.getX());
        translateTransition.setToY(transition.getY());
        translateTransition.setCycleCount(1);
        translateTransition.setAutoReverse(true);
        ParallelTransition parallelTransition = new ParallelTransition((Node)this, new Animation[]{scaleTransition, translateTransition});
        parallelTransition.play();
    }

    private Point2D calculateTransition(double scale, LocationPolygon polygon) {
        double polygonDistanceToCenterX = -(polygon.getCenterX() - this.getLayoutBounds().getWidth() / 2.0) * scale;
        double polygonDistanceToCenterY = -(polygon.getCenterY() - this.getLayoutBounds().getHeight() / 2.0) * scale;
        double boundingBoxCenterX = (this.foregroundPane.getBoundingBox().getMinX() + this.foregroundPane.getBoundingBox().getMaxX()) / 2.0;
        double boundingBoxCenterY = (this.foregroundPane.getBoundingBox().getMinY() + this.foregroundPane.getBoundingBox().getMaxY()) / 2.0;
        double bbCenterDistanceToCenterX = this.getLayoutBounds().getWidth() / 2.0 - boundingBoxCenterX;
        double bbCenterDistanceToCenterY = this.getLayoutBounds().getHeight() / 2.0 - boundingBoxCenterY;
        double transitionX = polygonDistanceToCenterX - bbCenterDistanceToCenterX;
        double transitionY = polygonDistanceToCenterY - bbCenterDistanceToCenterY;
        return new Point2D(transitionX, transitionY);
    }

    public void handleHoverUpdate(LocationPolygon locationPolygon, boolean hover) {
        if (hover) {
            this.locationHoverLevelList.add(locationPolygon);
        } else {
            this.locationHoverLevelList.remove(locationPolygon);
            if (!this.locationHoverLevelList.contains(locationPolygon)) {
                locationPolygon.setStrokeWidth(1.0);
            }
        }
        Collections.sort(this.locationHoverLevelList, (o1, o2) -> Integer.compare(o2.getLocationLevel(), o1.getLocationLevel()));
        InfoPane.info("");
        boolean first = true;
        LocationPolygon lastPolygon = null;
        for (LocationPolygon polygon : this.locationHoverLevelList) {
            if (lastPolygon == polygon) continue;
            if (first) {
                first = false;
                polygon.setStrokeWidth(3.0);
                try {
                    InfoPane.info(polygon.getLabel());
                }
                catch (NotAvailableException ex) {
                    LOGGER.warn("Could not resolve location label!", (Throwable)ex);
                }
            } else {
                polygon.setStrokeWidth(1.0);
            }
            lastPolygon = polygon;
        }
    }
}

