/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import org.openbase.bco.bcozy.view.location.AbstractUnitPolygon;
import org.openbase.bco.bcozy.view.location.TilePolygon;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.location.LocationDataType;

public abstract class LocationPolygon
extends AbstractUnitPolygon<LocationDataType.LocationData, LocationRemote> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TilePolygon.class);
    private boolean selected = false;
    private Shape cuttingShape = this;
    private int locationLevel;

    public LocationPolygon(double ... points) throws InstantiationException {
        super(points);
        this.setLocationStyle();
    }

    @Override
    public void init(UnitConfigType.UnitConfig unitConfig) throws InitializationException, InterruptedException {
        super.init(unitConfig);
        try {
            int level = 0;
            UnitConfigType.UnitConfig locationUnitConfig = unitConfig;
            while (!locationUnitConfig.getLocationConfig().getRoot()) {
                ++level;
                locationUnitConfig = Registries.getUnitRegistry((boolean)true).getUnitConfigById(locationUnitConfig.getPlacementConfig().getLocationId());
            }
            this.locationLevel = level;
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public int getLocationLevel() {
        return this.locationLevel;
    }

    public List<String> getChildIds() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)((LocationRemote)this.getUnitRemote()).getConfig()).getLocationConfig().getChildIdList();
        }
        catch (NullPointerException ex) {
            throw new NotAvailableException("ChildIdList", (Throwable)ex);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.changeStyleOnSelection(selected);
    }

    public void addCuttingShape(Shape additionalCuttingShape) {
        this.cuttingShape = Path.subtract((Shape)this.cuttingShape, (Shape)additionalCuttingShape);
        this.setClip((Node)this.cuttingShape);
    }

    protected abstract void changeStyleOnSelection(boolean var1);

    protected abstract void setLocationStyle();
}

