/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.bcozy.view.location.LocationPolygon;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import rst.domotic.unit.location.LocationDataType;

public class RegionPolygon
extends LocationPolygon {
    private boolean selectable;
    private final LocationPane locationPane;

    public RegionPolygon(LocationPane locationPane, double ... points) throws InstantiationException {
        super(points);
        this.locationPane = locationPane;
        this.selectable = false;
        this.setOnMouseClicked(event -> {
            try {
                event.consume();
                if (event.isStillSincePress()) {
                    if (event.getClickCount() == 1) {
                        locationPane.setSelectedLocation(this);
                    } else if (event.getClickCount() == 2) {
                        if (locationPane.getLastClickTarget().equals(this)) {
                            locationPane.autoFocusPolygonAnimated(this);
                        } else {
                            locationPane.getLastClickTarget().fireEvent((Event)event.copyFor(null, (EventTarget)locationPane.getLastClickTarget()));
                        }
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)LOGGER);
            }
        });
        this.setOnMouseEntered(event -> {
            try {
                event.consume();
                this.mouseEntered();
                InfoPane.info(this.getLabel());
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)LOGGER);
            }
        });
        this.setOnMouseExited(event -> {
            event.consume();
            this.mouseLeft();
            InfoPane.info("");
        });
    }

    @Override
    public void applyDataUpdate(LocationDataType.LocationData unitData) {
    }

    @Override
    protected void setLocationStyle() {
        this.setMainColor(Constants.REGION_FILL);
        this.setStroke((Paint)Color.WHITE);
        this.setStrokeWidth(0.0);
        this.setMouseTransparent(true);
    }

    @Override
    protected void changeStyleOnSelection(boolean selected) {
        if (selected) {
            this.setMainColor(Constants.TILE_SELECTION);
        } else {
            this.setMainColor(Constants.REGION_FILL);
        }
    }

    public void changeStyleOnSelectable(boolean selectable) {
        if (selectable) {
            this.selectable = true;
            this.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
            this.setStrokeWidth(0.5);
            this.setMouseTransparent(false);
        } else {
            this.selectable = false;
            this.getStrokeDashArray().clear();
            this.setStrokeWidth(0.0);
            this.setMouseTransparent(true);
        }
    }

    @Override
    protected void onColorChange(Color mainColor, Color customColor) {
        if (customColor.equals((Object)Color.TRANSPARENT)) {
            this.setFill((Paint)mainColor);
        } else {
            this.setFill((Paint)mainColor.interpolate(customColor, 0.5));
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    private void mouseEntered() {
        this.setStrokeWidth(2.0);
    }

    private void mouseLeft() {
        this.setStrokeWidth(0.5);
    }
}

