/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.bcozy.view.location.LocationPolygon;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import rst.domotic.unit.location.LocationDataType;

public class TilePolygon
extends LocationPolygon {
    private final LocationPane locationPane;

    public TilePolygon(LocationPane locationPane, double ... points) throws InstantiationException {
        super(points);
        this.locationPane = locationPane;
        this.setOnMouseClicked(event -> {
            try {
                if (event.isStillSincePress()) {
                    if (event.getClickCount() == 1) {
                        locationPane.setSelectedLocation(this);
                    } else if (event.getClickCount() == 2) {
                        locationPane.autoFocusPolygonAnimated(this);
                    }
                    event.consume();
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)LOGGER);
            }
        });
        this.hoverProperty().addListener((observable, oldValue, newValue) -> locationPane.handleHoverUpdate(this, (boolean)newValue));
    }

    @Override
    public void applyDataUpdate(LocationDataType.LocationData unitData) {
        switch (unitData.getPresenceState().getValue()) {
            case PRESENT: {
                this.setCustomColor(Color.GREEN.brighter());
                break;
            }
            case ABSENT: 
            case UNKNOWN: {
                this.setCustomColor(Color.TRANSPARENT);
                break;
            }
            default: {
                ExceptionPrinter.printHistory((Throwable)new EnumNotSupportedException((Enum)unitData.getPresenceState().getValue(), (Object)this), (Logger)LOGGER);
            }
        }
    }

    @Override
    protected void setLocationStyle() {
        this.setMainColor(Color.TRANSPARENT);
        this.setStroke((Paint)Color.WHITE);
        this.setStrokeWidth(1.0);
    }

    @Override
    protected void changeStyleOnSelection(boolean selected) {
        if (selected) {
            this.setMainColor(Constants.TILE_SELECTION);
        } else {
            this.setMainColor(Color.TRANSPARENT);
        }
    }

    @Override
    protected void onColorChange(Color mainColor, Color customColor) {
        if (customColor.equals((Object)Color.TRANSPARENT)) {
            this.setFill((Paint)mainColor);
        } else {
            this.setFill((Paint)mainColor.interpolate(customColor, 0.5));
        }
    }
}

