/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import com.google.protobuf.GeneratedMessage;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.openbase.bco.bcozy.view.generic.WidgetPane;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.bcozy.view.pane.unit.UnitPaneFactoryImpl;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class UnitButtonGrouped
extends Pane {
    protected final Logger LOGGER = LoggerFactory.getLogger(UnitButtonGrouped.class);
    private final FlowPane groupingPane;
    private final StackPane stackPane;
    private final Text unitCount;
    private final GridPane iconPane;
    private String locationId = new String();
    private boolean expanded = false;
    private Rectangle clipRectangle1;

    public UnitButtonGrouped() {
        this.groupingPane = new FlowPane();
        this.groupingPane.setPrefWrapLength(104.0);
        this.iconPane = new GridPane();
        this.stackPane = new StackPane();
        this.unitCount = new Text("0");
        this.unitCount.setTextAlignment(TextAlignment.LEFT);
        this.unitCount.setStyle("-fx-font: 10pt Tahoma; -fx-fill: black; -fx-stroke: white; -fx-stroke-width: 0.2px;");
        this.unitCount.textProperty().bind((ObservableValue)Bindings.size((ObservableList)this.groupingPane.getChildren()).asString());
        this.iconPane.getChildren().add((Object)this.unitCount);
        this.stackPane.getChildren().add((Object)this.iconPane);
        this.stackPane.getChildren().add((Object)this.groupingPane);
        this.getChildren().add((Object)this.stackPane);
        this.clipRectangle1 = new Rectangle(32.0, 32.0);
        this.setClip((Node)this.clipRectangle1);
        this.groupingPane.layoutBoundsProperty().addListener((ov, oldValue, newValue) -> {
            this.clipRectangle1.setWidth(newValue.getWidth());
            this.clipRectangle1.setHeight(newValue.getHeight());
        });
        EventHandler mouseEventHandler = event -> {
            event.consume();
            if (!this.expanded) {
                this.expand();
                this.expanded = true;
            }
        };
        EventHandler mouseExitedHandler = event -> {
            event.consume();
            if (this.expanded) {
                this.shrink();
                this.expanded = false;
            }
        };
        this.stackPane.setOnMouseClicked(mouseEventHandler);
        this.stackPane.setOnMouseExited(mouseExitedHandler);
        this.getStyleClass().clear();
        this.getStyleClass().addAll((Object[])new String[]{"units-button"});
    }

    public void addUnit(UnitRemote<? extends GeneratedMessage> unit) throws InterruptedException, CouldNotPerformException {
        try {
            AbstractUnitPane content = UnitPaneFactoryImpl.getInstance().newInitializedInstance((UnitConfigType.UnitConfig)unit.getConfig());
            content.setDisplayMode(WidgetPane.DisplayMode.ICON_ONLY);
            if (this.groupingPane.getChildren().isEmpty()) {
                SVGGlyphIcon icon = content.getIconSymbol();
                this.iconPane.getChildren().add((Object)icon);
                this.locationId = ((UnitConfigType.UnitConfig)unit.getConfig()).getPlacementConfig().getLocationId();
            }
            content.setVisible(false);
            content.getStyleClass().add((Object)"units-button");
            content.setStyle("-fx-background-color: rgb(64.0, 64.0, 64.0)");
            this.groupingPane.getChildren().add((Object)content);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not create grouped unit button for config " + (Object)((Object)this), (Throwable)ex);
        }
    }

    private void expand() {
        this.iconPane.setVisible(false);
        this.groupingPane.getChildren().forEach(node -> node.setVisible(true));
        this.clipRectangle1.setWidth(this.groupingPane.getWidth());
        this.clipRectangle1.setHeight(this.groupingPane.getHeight());
    }

    private void shrink() {
        this.groupingPane.getChildren().forEach(node -> node.setVisible(false));
        this.iconPane.setVisible(true);
        this.clipRectangle1.setWidth(32.0);
        this.clipRectangle1.setHeight(32.0);
    }

    public String getLocationId() {
        return this.locationId;
    }
}

