/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.user.UserRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class UserPane
extends BorderPane
implements Shutdownable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPane.class);
    private SVGGlyphIcon userIcon = new SVGGlyphIcon(MaterialIcon.PERSON, 42.0, false);
    private SVGGlyphIcon atHomeIcon = new SVGGlyphIcon(MaterialIcon.SEARCH, 16.0, true);
    private Label userNameLabel;
    private ObserverLabel userStateLabel;
    private UserRemote user;
    private final GridPane userIconPane = new GridPane();

    public UserPane() {
        this.userIconPane.setVgap(10.0);
        this.userIconPane.setHgap(10.0);
        this.userIconPane.add((Node)this.userIcon, 0, 0, 5, 5);
        this.userIconPane.add((Node)this.atHomeIcon, 4, 4, 1, 1);
        this.userNameLabel = new Label();
        this.userNameLabel.getStyleClass().add((Object)"bold-label");
        HBox nameAndGuestLayout = new HBox(10.0);
        nameAndGuestLayout.getChildren().addAll((Object[])new Node[]{this.userNameLabel});
        nameAndGuestLayout.setAlignment(Pos.CENTER);
        this.userStateLabel = new ObserverLabel("---");
        VBox nameAndStateLayout = new VBox(5.0);
        nameAndStateLayout.setAlignment(Pos.CENTER);
        nameAndStateLayout.getChildren().addAll((Object[])new Node[]{nameAndGuestLayout, this.userStateLabel});
        this.setLeft((Node)this.userIconPane);
        this.setCenter((Node)nameAndStateLayout);
    }

    public void init(UnitConfigType.UnitConfig userUniConfig) throws InitializationException, InterruptedException {
        try {
            this.user = (UserRemote)Units.getUnit((UnitConfigType.UnitConfig)userUniConfig, (boolean)false, (Class)Units.USER);
            this.user.addDataObserver((source, data) -> Platform.runLater(() -> this.updateDynamicComponents()));
            this.updateDynamicComponents();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    private void updateDynamicComponents() {
        try {
            if (this.user == null || !this.user.isDataAvailable()) {
                return;
            }
            this.updateUserPresenceState();
            this.userNameLabel.setText(this.user.getName());
            this.updateUserState();
            this.updateBounds();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not update dynamic components!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    private void updateUserState() {
        String userState = null;
        try {
            try {
                if (!this.user.getUserActivityState().hasActivityId() || this.user.getUserActivityState().getActivityId().isEmpty()) {
                    throw new NotAvailableException("UserActivity");
                }
                userState = Registries.getUserActivityRegistry().getUserActivityConfigById(this.user.getUserActivityState().getActivityId()).getLabel();
            }
            catch (CouldNotPerformException ex) {
                userState = this.user.getUserPresenceState().getValue().name();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            this.userStateLabel.setIdentifier(userState);
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((String)"Could not update user presence state!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    private void updateUserPresenceState() {
        try {
            switch (this.user.getUserPresenceState().getValue()) {
                case AT_HOME: 
                case SHORT_AT_HOME: 
                case SOON_AWAY: {
                    this.userIconPane.getChildren().remove((Object)this.atHomeIcon);
                    this.atHomeIcon = new SVGGlyphIcon(MaterialIcon.HOME, 16.0, true);
                    this.userIconPane.add((Node)this.atHomeIcon, 4, 4, 1, 1);
                    this.userIcon.setForegroundIconColor(Color.DODGERBLUE);
                    this.setManaged(true);
                    this.setVisible(true);
                    break;
                }
                case AWAY: 
                case SHORT_AWAY: 
                case SOON_AT_HOME: {
                    this.atHomeIcon = new SVGGlyphIcon(MaterialIcon.DIRECTIONS_WALK, 16.0, true);
                    this.userIcon.setForegroundIconColor(Color.LIGHTGRAY);
                    if (!((UnitConfigType.UnitConfig)this.user.getConfig()).getUserConfig().getOccupant()) {
                        this.setManaged(false);
                        this.setVisible(false);
                    }
                    break;
                }
                case UNKNOWN: {
                    this.atHomeIcon = new SVGGlyphIcon(MaterialIcon.SEARCH, 16.0, true);
                    this.userIcon.setForegroundIconColor(Color.DARKGREY);
                    if (!((UnitConfigType.UnitConfig)this.user.getConfig()).getUserConfig().getOccupant()) {
                        this.setManaged(false);
                        this.setVisible(false);
                    }
                    break;
                }
                default: {
                    ExceptionPrinter.printHistory((Throwable)new EnumNotSupportedException((Enum)this.user.getUserPresenceState().getValue(), (Object)this), (Logger)LOGGER);
                    break;
                }
            }
        }
        catch (NotAvailableException ex) {
            ExceptionPrinter.printHistory((String)"Could not update user presence state!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    public void shutdown() {
    }
}

