/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.openbase.bco.dal.lib.jp.JPRemoteMethod;
import org.openbase.bco.dal.lib.jp.JPRemoteMethodParameters;
import org.openbase.bco.dal.lib.jp.JPRemoteService;
import org.openbase.jps.core.JPService;
import org.openbase.jps.preset.JPDebugMode;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.Scope;

public class DALRemote {
    private static final Logger logger = LoggerFactory.getLogger(DALRemote.class);
    public static final String APP_NAME = DALRemote.class.getSimpleName();

    public DALRemote() throws InitializationException {
        try {
            RSBRemoteService remote;
            try {
                remote = (RSBRemoteService)((Class)((JPRemoteService)JPService.getProperty(JPRemoteService.class)).getValue()).newInstance();
            }
            catch (InstantiationException ex) {
                throw new CouldNotPerformException("Could not build remote instance!", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new CouldNotPerformException("Could not access remote!", (Throwable)ex);
            }
            remote.init((Scope)((JPScope)JPService.getProperty(JPScope.class)).getValue());
            remote.activate();
            Method remoteMethod = (Method)((JPRemoteMethod)JPService.getProperty(JPRemoteMethod.class)).getValue();
            ArrayList<Object> parameterList = new ArrayList<Object>(remoteMethod.getParameterTypes().length);
            for (Class<?> parameterClass : remoteMethod.getParameterTypes()) {
                Method parameterProcessorMethod;
                try {
                    parameterProcessorMethod = parameterClass.getMethod("valueOf", String.class);
                }
                catch (Exception ex) {
                    throw new CouldNotPerformException("Could not find parameter processor method!", (Throwable)ex);
                }
                try {
                    ArrayList parameterStringList = new ArrayList((Collection)((JPRemoteMethodParameters)JPService.getProperty(JPRemoteMethodParameters.class)).getValue());
                    parameterList.add(parameterProcessorMethod.invoke(null, parameterStringList.remove(0)));
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException ex) {
                    throw new CouldNotPerformException("Could transform parameter value into parameter!", (Throwable)ex);
                }
            }
            try {
                remoteMethod.invoke((Object)remote, parameterList.toArray());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new CouldNotPerformException("Could not invoke remote method!", (Throwable)ex);
            }
            remote.shutdown();
        }
        catch (Exception ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Throwable {
        logger.info("Start " + APP_NAME + "...");
        JPService.setApplicationName((String)APP_NAME);
        JPService.registerProperty(JPDebugMode.class);
        JPService.registerProperty(JPScope.class);
        JPService.registerProperty(JPRemoteService.class);
        JPService.registerProperty(JPRemoteMethod.class);
        JPService.registerProperty(JPRemoteMethodParameters.class);
        JPService.parseAndExitOnError((String[])args);
        try {
            new DALRemote();
        }
        catch (InitializationException ex) {
            throw (InitializationException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)logger, (LogLevel)LogLevel.ERROR);
        }
        logger.info(APP_NAME + " successfully started.");
    }
}

