/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.control.action;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.openbase.bco.dal.remote.control.action.ActionService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactory;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactoryImpl;
import org.openbase.bco.registry.device.lib.DeviceRegistry;
import org.openbase.bco.registry.device.remote.CachedDeviceRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.Initializable;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.action.ActionConfigType;
import rst.domotic.action.ActionDataType;
import rst.domotic.state.ActionStateType;

public class Action
implements ActionService,
Initializable<ActionConfigType.ActionConfig> {
    private static final Logger logger = LoggerFactory.getLogger(Action.class);
    private ActionConfigType.ActionConfig.Builder config;
    private final ActionDataType.ActionData.Builder data;
    private ServiceRemoteFactory serviceRemoteFactory;
    private DeviceRegistry deviceRegistry;
    private AbstractServiceRemote serviceRemote;
    private Future executionFuture;
    private final SyncObject executionSync = new SyncObject(Action.class);

    public Action() {
        this.data = ActionDataType.ActionData.newBuilder();
    }

    public void init(ActionConfigType.ActionConfig config) throws InitializationException, InterruptedException {
        try {
            this.config = config.toBuilder();
            this.data.setLabel(config.getLabel());
            this.deviceRegistry = CachedDeviceRegistryRemote.getRegistry();
            this.serviceRemoteFactory = ServiceRemoteFactoryImpl.getInstance();
            CachedDeviceRegistryRemote.waitForData();
            this.serviceRemote = this.serviceRemoteFactory.createAndInitServiceRemote(config.getServiceType(), this.deviceRegistry.getUnitConfigById(config.getUnitId()));
            this.serviceRemote.activate();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws CouldNotPerformException {
        SyncObject syncObject = this.executionSync;
        synchronized (syncObject) {
            FutureTask<Void> task = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        Action.this.updateActionState(ActionStateType.ActionState.State.INITIATING);
                        try {
                            Action.this.acquireService();
                        }
                        catch (CouldNotPerformException e) {
                            ExceptionPrinter.printHistory((Throwable)e, (Logger)logger);
                            Action.this.updateActionState(ActionStateType.ActionState.State.REJECTED);
                        }
                        Action.this.updateActionState(ActionStateType.ActionState.State.EXECUTING);
                        try {
                            Action.this.serviceRemote.applyAction(Action.this.getConfig());
                            Action.this.updateActionState(ActionStateType.ActionState.State.FINISHING);
                            Action.this.releaseService();
                            Action.this.updateActionState(ActionStateType.ActionState.State.FINISHED);
                        }
                        catch (InterruptedException ex) {
                            Action.this.updateActionState(ActionStateType.ActionState.State.ABORTING);
                            Action.this.releaseService();
                            Action.this.updateActionState(ActionStateType.ActionState.State.ABORTED);
                            throw ex;
                        }
                        catch (NullPointerException | CouldNotPerformException ex) {
                            Action.this.updateActionState(ActionStateType.ActionState.State.EXECUTION_FAILED);
                            Action.this.releaseService();
                            throw ex;
                        }
                    }
                    catch (Exception ex) {
                        throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Execution " + Action.this.data.getActionState().getValue() + "!", (Throwable)ex), (Logger)logger, (LogLevel)LogLevel.WARN);
                    }
                    return null;
                }
            });
            this.executionFuture = GlobalExecutionService.submit(task);
        }
    }

    private void acquireService() throws CouldNotPerformException {
        logger.info("Acquire service for execution of " + this);
    }

    private void releaseService() {
        try {
            logger.info("Release acquired services of " + this);
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("FatalExecutionError: Could not release service!", (Throwable)ex), (Logger)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinalization() throws CouldNotPerformException, InterruptedException {
        Future currentExecution;
        SyncObject syncObject = this.executionSync;
        synchronized (syncObject) {
            if (this.executionFuture == null) {
                throw new InvalidStateException("No execution running!");
            }
            currentExecution = this.executionFuture;
        }
        try {
            currentExecution.get();
        }
        catch (ExecutionException ex) {
            throw new CouldNotPerformException("Could not wait for execution!", (Throwable)ex);
        }
    }

    public ActionConfigType.ActionConfig getConfig() {
        return this.config.build();
    }

    private void updateActionState(ActionStateType.ActionState.State state) {
        this.data.setActionState(ActionStateType.ActionState.newBuilder().setValue(state));
        logger.info("Stateupdate[" + state.name() + "] of " + this);
    }

    public String toString() {
        if (this.config == null) {
            return this.getClass().getSimpleName() + "[?]";
        }
        return this.getClass().getSimpleName() + "[" + this.config.getOriginId() + "|" + this.config.getUnitId() + "|" + this.config.getServiceType() + "|" + this.config.getServiceAttribute() + "|" + this.config.getUnitId() + "]";
    }
}

