/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.exception.ShutdownException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Manageable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.action.ActionConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;

public abstract class AbstractServiceRemote<S extends Service, ST extends GeneratedMessage>
implements Service,
Manageable<UnitConfigType.UnitConfig> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceTemplateType.ServiceTemplate.ServiceType serviceType;
    private final Map<String, UnitRemote> unitRemoteMap;
    private final Map<String, S> serviceMap;
    private UnitRemoteFactory factory = UnitRemoteFactoryImpl.getInstance();
    private ST serviceState = null;
    private final Observer dataObserver;
    protected final ObservableImpl<ST> serviceStateObservable = new ObservableImpl();
    private final SyncObject syncObject = new SyncObject("ServiceStateComputationLock");

    public AbstractServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) {
        this.serviceType = serviceType;
        this.unitRemoteMap = new HashMap<String, UnitRemote>();
        this.serviceMap = new HashMap<String, S>();
        this.dataObserver = (source, data) -> this.updateServiceState();
    }

    protected abstract ST computeServiceState() throws CouldNotPerformException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceState() throws CouldNotPerformException {
        SyncObject syncObject = this.syncObject;
        synchronized (syncObject) {
            this.serviceState = this.computeServiceState();
        }
        this.serviceStateObservable.notifyObservers(this.serviceState);
    }

    public ST getServiceState() throws NotAvailableException {
        if (this.serviceState == null) {
            throw new NotAvailableException("ServiceState");
        }
        return this.serviceState;
    }

    public void addDataObserver(Observer<ST> observer) {
        this.serviceStateObservable.addObserver(observer);
    }

    public void removeDataObserver(Observer<ST> observer) {
        this.serviceStateObservable.removeObserver(observer);
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            if (!AbstractServiceRemote.verifyServiceCompatibility(config, this.serviceType)) {
                throw new NotSupportedException("Unit template is not compatible with given ServiceType[" + this.serviceType.name() + "]!", (Object)config.getId(), (Object)this);
            }
            UnitRemote remote = this.factory.newInitializedInstance(config);
            try {
                this.serviceMap.put(config.getId(), remote);
            }
            catch (ClassCastException ex) {
                throw new NotSupportedException("Remote does not implement service interface!", (Object)remote, (Object)this, (Throwable)ex);
            }
            this.unitRemoteMap.put(config.getId(), remote);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(Collection<UnitConfigType.UnitConfig> configs) throws InitializationException, InterruptedException {
        try {
            if (configs.isEmpty()) {
                throw new NotAvailableException("UnitConfigs");
            }
            MultiException.ExceptionStack exceptionStack = null;
            for (UnitConfigType.UnitConfig config : configs) {
                try {
                    this.init(config);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), exceptionStack);
                }
            }
            MultiException.checkAndThrow((String)"Could not activate all service units!", exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        try {
            MultiException.ExceptionStack exceptionStack = null;
            for (UnitRemote remote : this.unitRemoteMap.values()) {
                try {
                    remote.addDataObserver(this.dataObserver);
                    remote.activate();
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)remote, (Exception)((Object)ex), exceptionStack);
                }
            }
            MultiException.checkAndThrow((String)"Could not activate all internal service units!", exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not activate service remote!", (Throwable)ex);
        }
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        MultiException.ExceptionStack exceptionStack = null;
        for (UnitRemote remote : this.unitRemoteMap.values()) {
            remote.removeDataObserver(this.dataObserver);
            try {
                remote.deactivate();
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)remote, (Exception)((Object)ex), exceptionStack);
            }
        }
        MultiException.checkAndThrow((String)"Could not deactivate all service units!", exceptionStack);
    }

    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (InterruptedException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new ShutdownException((Object)this, ex), (Logger)this.logger);
        }
    }

    public boolean isActive() {
        return this.unitRemoteMap.values().stream().allMatch(remote -> remote.isActive());
    }

    public UnitRemoteFactory getFactory() {
        return this.factory;
    }

    public void setFactory(UnitRemoteFactory factory) {
        this.factory = factory;
    }

    public Collection<UnitRemote> getInternalUnits() {
        return Collections.unmodifiableCollection(this.unitRemoteMap.values());
    }

    public Collection<S> getServices() {
        return Collections.unmodifiableCollection(this.serviceMap.values());
    }

    public ServiceTemplateType.ServiceTemplate.ServiceType getServiceType() {
        return this.serviceType;
    }

    public Future<Void> applyAction(ActionConfigType.ActionConfig actionConfig) throws CouldNotPerformException, InterruptedException {
        try {
            if (!actionConfig.getServiceType().equals((Object)this.getServiceType())) {
                throw new VerificationFailedException("Service type is not compatible to given action config!");
            }
            ArrayList<Future> actionFutureList = new ArrayList<Future>();
            for (UnitRemote remote : this.getInternalUnits()) {
                actionFutureList.add(remote.applyAction(actionConfig));
            }
            return GlobalExecutionService.allOf(actionFutureList, (Object)null);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not apply action!", (Throwable)ex);
        }
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        for (UnitRemote remote : this.unitRemoteMap.values()) {
            remote.waitForData();
        }
        this.serviceStateObservable.waitForValue();
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        for (UnitRemote remote : this.unitRemoteMap.values()) {
            this.waitForData(timeout, timeUnit);
        }
        this.serviceStateObservable.waitForValue(timeout, timeUnit);
    }

    public boolean isConnected() {
        return this.getInternalUnits().stream().noneMatch(unitRemote -> !unitRemote.isConnected());
    }

    public boolean isDataAvailable() {
        return this.getInternalUnits().stream().noneMatch(unitRemote -> !unitRemote.isDataAvailable());
    }

    public static boolean verifyServiceCompatibility(UnitConfigType.UnitConfig unitConfig, ServiceTemplateType.ServiceTemplate.ServiceType serviceType) {
        return unitConfig.getServiceConfigList().stream().anyMatch(serviceConfig -> serviceConfig.getServiceTemplate().getType() == serviceType);
    }
}

