/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.BlindStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.BlindStateOperationService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BlindStateType;
import rst.timing.TimestampType;

public class BlindStateServiceRemote
extends AbstractServiceRemote<BlindStateOperationService, BlindStateType.BlindState>
implements BlindStateOperationServiceCollection {
    public BlindStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.BLIND_STATE_SERVICE);
    }

    public Collection<BlindStateOperationService> getBlindStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected BlindStateType.BlindState computeServiceState() throws CouldNotPerformException {
        int serviceNumber = this.getBlindStateOperationServices().size();
        int stop = 0;
        int down = 0;
        int up = 0;
        float openingRatioAverage = 0.0f;
        for (BlindStateOperationService service : this.getBlindStateOperationServices()) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --serviceNumber;
                continue;
            }
            switch (service.getBlindState().getMovementState()) {
                case DOWN: {
                    ++down;
                    break;
                }
                case STOP: {
                    ++stop;
                    break;
                }
                case UP: {
                    ++up;
                }
            }
            openingRatioAverage = (float)((double)openingRatioAverage + service.getBlindState().getOpeningRatio());
        }
        BlindStateType.BlindState.MovementState mostOccurences = stop >= up && stop >= down ? BlindStateType.BlindState.MovementState.STOP : (up >= stop && up >= down ? BlindStateType.BlindState.MovementState.UP : BlindStateType.BlindState.MovementState.DOWN);
        return BlindStateType.BlindState.newBuilder().setMovementState(mostOccurences).setOpeningRatio((double)(openingRatioAverage /= (float)serviceNumber)).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public BlindStateType.BlindState getBlindState() throws NotAvailableException {
        return (BlindStateType.BlindState)this.getServiceState();
    }
}

