/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.awt.Color;
import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.ColorStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.ColorStateOperationService;
import org.openbase.bco.dal.lib.transform.HSBColorToRGBColorTransformer;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ColorStateType;
import rst.timing.TimestampType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;

public class ColorStateServiceRemote
extends AbstractServiceRemote<ColorStateOperationService, ColorStateType.ColorState>
implements ColorStateOperationServiceCollection {
    public ColorStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE);
    }

    public Collection<ColorStateOperationService> getColorStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected ColorStateType.ColorState computeServiceState() throws CouldNotPerformException {
        double averageRed = 0.0;
        double averageGreen = 0.0;
        double averageBlue = 0.0;
        int amount = this.getColorStateOperationServices().size();
        Collection<ColorStateOperationService> colorStateOperationServicCollection = this.getColorStateOperationServices();
        for (ColorStateOperationService service : colorStateOperationServicCollection) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            Color color = HSBColorToRGBColorTransformer.transform((HSBColorType.HSBColor)service.getColorState().getColor().getHsbColor());
            averageRed += (double)color.getRed();
            averageGreen += (double)color.getGreen();
            averageBlue += (double)color.getBlue();
        }
        HSBColorType.HSBColor hsbColor = HSBColorToRGBColorTransformer.transform((Color)new Color((int)(averageRed /= (double)amount), (int)(averageGreen /= (double)amount), (int)(averageBlue /= (double)amount)));
        return ColorStateType.ColorState.newBuilder().setColor(ColorType.Color.newBuilder().setType(ColorType.Color.Type.HSB).setHsbColor(hsbColor)).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public ColorStateType.ColorState getColorState() throws NotAvailableException {
        return (ColorStateType.ColorState)this.getServiceState();
    }
}

