/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.ContactStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.ContactStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ContactStateType;
import rst.timing.TimestampType;

public class ContactStateServiceRemote
extends AbstractServiceRemote<ContactStateProviderService, ContactStateType.ContactState>
implements ContactStateProviderServiceCollection {
    public ContactStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.CONTACT_STATE_SERVICE);
    }

    public Collection<ContactStateProviderService> getContactStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected ContactStateType.ContactState computeServiceState() throws CouldNotPerformException {
        ContactStateType.ContactState.State contactValue = ContactStateType.ContactState.State.CLOSED;
        for (ContactStateProviderService provider : this.getContactStateProviderServices()) {
            if (!((UnitRemote)provider).isDataAvailable() || provider.getContactState().getValue() != ContactStateType.ContactState.State.OPEN) continue;
            contactValue = ContactStateType.ContactState.State.OPEN;
        }
        return ContactStateType.ContactState.newBuilder().setValue(contactValue).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public ContactStateType.ContactState getContactState() throws NotAvailableException {
        return (ContactStateType.ContactState)this.getServiceState();
    }
}

