/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.MotionStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.MotionStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.MotionStateType;
import rst.timing.TimestampType;

public class MotionStateServiceRemote
extends AbstractServiceRemote<MotionStateProviderService, MotionStateType.MotionState>
implements MotionStateProviderServiceCollection {
    public MotionStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.MOTION_STATE_SERVICE);
    }

    public Collection<MotionStateProviderService> getMotionStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected MotionStateType.MotionState computeServiceState() throws CouldNotPerformException {
        MotionStateType.MotionState.State motionValue = MotionStateType.MotionState.State.NO_MOTION;
        long lastMotion = 0L;
        for (MotionStateProviderService provider : this.getMotionStateProviderServices()) {
            if (!((UnitRemote)provider).isDataAvailable()) continue;
            MotionStateType.MotionState motionState = provider.getMotionState();
            if (motionState.getValue() == MotionStateType.MotionState.State.MOTION) {
                motionValue = MotionStateType.MotionState.State.MOTION;
            }
            if (!motionState.hasLastMotion() || motionState.getLastMotion().getTime() <= lastMotion) continue;
            lastMotion = motionState.getLastMotion().getTime();
        }
        return MotionStateType.MotionState.newBuilder().setValue(motionValue).setLastMotion(TimestampType.Timestamp.newBuilder().setTime(lastMotion)).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public MotionStateType.MotionState getMotionState() throws NotAvailableException {
        return (MotionStateType.MotionState)this.getServiceState();
    }
}

