/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactory;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.processing.StringProcessor;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;

public class ServiceRemoteFactoryImpl
implements ServiceRemoteFactory {
    private static ServiceRemoteFactory instance;

    private ServiceRemoteFactoryImpl() {
    }

    public static synchronized ServiceRemoteFactory getInstance() {
        if (instance == null) {
            instance = new ServiceRemoteFactoryImpl();
        }
        return instance;
    }

    @Override
    public AbstractServiceRemote createAndInitServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Collection<UnitConfigType.UnitConfig> unitConfigs) throws CouldNotPerformException, InterruptedException {
        AbstractServiceRemote serviceRemote = this.createServiceRemote(serviceType);
        serviceRemote.init(unitConfigs);
        return serviceRemote;
    }

    @Override
    public AbstractServiceRemote createAndInitServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException, InterruptedException {
        AbstractServiceRemote serviceRemote = this.createServiceRemote(serviceType);
        serviceRemote.init(unitConfig);
        return serviceRemote;
    }

    @Override
    public AbstractServiceRemote createServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws CouldNotPerformException {
        try {
            return ServiceRemoteFactoryImpl.instantiatServiceRemote(ServiceRemoteFactoryImpl.loadServiceRemoteClass(serviceType));
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not create service remote!", (Throwable)ex);
        }
    }

    public static Class<? extends AbstractServiceRemote> loadServiceRemoteClass(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws CouldNotPerformException {
        String remoteClassName = AbstractServiceRemote.class.getPackage().getName() + "." + StringProcessor.transformUpperCaseToCamelCase((String)serviceType.name()) + "Remote";
        try {
            return ServiceRemoteFactoryImpl.class.getClassLoader().loadClass(remoteClassName);
        }
        catch (ClassNotFoundException | NullPointerException ex) {
            throw new CouldNotPerformException("Could not detect service remote class for ServiceType[" + serviceType.name() + "]!", (Throwable)ex);
        }
    }

    private static AbstractServiceRemote instantiatServiceRemote(Class<? extends AbstractServiceRemote> serviceRemoteClass) throws InstantiationException {
        try {
            AbstractServiceRemote remote = serviceRemoteClass.newInstance();
            return remote;
        }
        catch (IllegalAccessException | java.lang.InstantiationException ex) {
            throw new InstantiationException((Object)("Could not instantiate service remote out of Class[" + serviceRemoteClass.getName() + "]"), (Throwable)ex);
        }
    }
}

