/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.SmokeStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.SmokeStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.SmokeStateType;
import rst.timing.TimestampType;

public class SmokeStateServiceRemote
extends AbstractServiceRemote<SmokeStateProviderService, SmokeStateType.SmokeState>
implements SmokeStateProviderServiceCollection {
    public SmokeStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.SMOKE_STATE_SERVICE);
    }

    public Collection<SmokeStateProviderService> getSmokeStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected SmokeStateType.SmokeState computeServiceState() throws CouldNotPerformException {
        boolean someSmoke = false;
        SmokeStateType.SmokeState.State smokeValue = SmokeStateType.SmokeState.State.NO_SMOKE;
        Collection<SmokeStateProviderService> smokeStateProviderServices = this.getSmokeStateProviderServices();
        int amount = smokeStateProviderServices.size();
        double averageSmokeLevel = 0.0;
        for (SmokeStateProviderService provider : smokeStateProviderServices) {
            if (((UnitRemote)provider).isDataAvailable()) {
                --amount;
                continue;
            }
            SmokeStateType.SmokeState smokeState = provider.getSmokeState();
            if (smokeState.getValue() == SmokeStateType.SmokeState.State.SMOKE) {
                smokeValue = SmokeStateType.SmokeState.State.SMOKE;
                break;
            }
            if (smokeState.getValue() == SmokeStateType.SmokeState.State.SOME_SMOKE) {
                someSmoke = true;
            }
            averageSmokeLevel += smokeState.getSmokeLevel();
        }
        if (someSmoke) {
            smokeValue = SmokeStateType.SmokeState.State.SOME_SMOKE;
        }
        return SmokeStateType.SmokeState.newBuilder().setValue(smokeValue).setSmokeLevel(averageSmokeLevel /= (double)amount).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public SmokeStateType.SmokeState getSmokeState() throws NotAvailableException {
        return (SmokeStateType.SmokeState)this.getServiceState();
    }
}

