/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.TargetTemperatureStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.TargetTemperatureStateOperationService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.TemperatureStateType;
import rst.timing.TimestampType;

public class TargetTemperatureStateServiceRemote
extends AbstractServiceRemote<TargetTemperatureStateOperationService, TemperatureStateType.TemperatureState>
implements TargetTemperatureStateOperationServiceCollection {
    public TargetTemperatureStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.TARGET_TEMPERATURE_STATE_SERVICE);
    }

    public Collection<TargetTemperatureStateOperationService> getTargetTemperatureStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected TemperatureStateType.TemperatureState computeServiceState() throws CouldNotPerformException {
        Double average = 0.0;
        Collection<TargetTemperatureStateOperationService> targetTemperatureStateOperationServices = this.getTargetTemperatureStateOperationServices();
        int amount = targetTemperatureStateOperationServices.size();
        for (TargetTemperatureStateOperationService service : targetTemperatureStateOperationServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            average = average + service.getTargetTemperatureState().getTemperature();
        }
        average = average / (double)amount;
        return TemperatureStateType.TemperatureState.newBuilder().setTemperature(average.doubleValue()).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public TemperatureStateType.TemperatureState getTargetTemperatureState() throws NotAvailableException {
        return (TemperatureStateType.TemperatureState)this.getServiceState();
    }
}

