/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.concurrent.Future;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.registry.device.lib.DeviceRegistry;
import org.openbase.bco.registry.device.remote.CachedDeviceRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.AbstractConfigurableRemote;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.extension.rst.iface.ScopeProvider;
import org.openbase.jul.pattern.Remote;
import rsb.Scope;
import rst.domotic.action.ActionConfigType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.scene.SceneConfigType;
import rst.rsb.ScopeType;

public abstract class AbstractUnitRemote<M extends GeneratedMessage>
extends AbstractConfigurableRemote<M, UnitConfigType.UnitConfig>
implements UnitRemote<M, UnitConfigType.UnitConfig> {
    private UnitTemplateType.UnitTemplate template;
    private DeviceRegistry deviceRegistry;

    public AbstractUnitRemote(Class<M> dataClass) {
        super(dataClass, UnitConfigType.UnitConfig.class);
    }

    protected DeviceRegistry getDeviceRegistry() throws InterruptedException, CouldNotPerformException {
        if (this.deviceRegistry == null) {
            this.deviceRegistry = CachedDeviceRegistryRemote.getRegistry();
            CachedDeviceRegistryRemote.waitForData();
        }
        return this.deviceRegistry;
    }

    @Override
    public void initById(String id) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getDeviceRegistry().getUnitConfigById(id));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    @Override
    public void initByLabel(String label) throws InitializationException, InterruptedException {
        try {
            List unitConfigList = this.getDeviceRegistry().getUnitConfigsByLabel(label);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("Unit with Label[" + label + "]");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit with Label[" + label + "] is not unique!");
            }
            this.init((GeneratedMessage)unitConfigList.get(0));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    @Override
    public void init(ScopeType.Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getDeviceRegistry().getUnitConfigByScope(scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    @Override
    public void init(Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeTransformer.transform((Scope)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(String scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(String label, ScopeProvider location) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)label, (String)this.getDataClass().getSimpleName(), (ScopeType.Scope)location.getScope()));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        if (config == null) {
            throw new NotAvailableException("UnitConfig");
        }
        try {
            if (((UnitConfigType.UnitConfig)this.getConfig()).equals((Object)config)) {
                this.logger.debug("Skip config update because no config change detected!");
                return config;
            }
        }
        catch (NotAvailableException notAvailableException) {
            // empty catch block
        }
        this.template = this.getDeviceRegistry().getUnitTemplateByType(config.getType());
        return (UnitConfigType.UnitConfig)super.applyConfigUpdate((GeneratedMessage)config);
    }

    public UnitTemplateType.UnitTemplate.UnitType getType() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getType();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit type", ex);
        }
    }

    public UnitTemplateType.UnitTemplate getTemplate() throws NotAvailableException {
        if (this.template == null) {
            throw new NotAvailableException("UnitTemplate");
        }
        return this.template;
    }

    public String getLabel() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getLabel();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public ScopeType.Scope getScope() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getScope();
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public Future<Void> applyAction(ActionConfigType.ActionConfig actionConfig) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)actionConfig, (Remote)this, Void.class);
    }

    public Future<SceneConfigType.SceneConfig> recordSnapshot() throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Remote)this, SceneConfigType.SceneConfig.class);
    }
}

