/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.ColorableLight;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.pattern.Remote;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.ColorableLightDataType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;
import rst.vision.RGBColorType;

public class ColorableLightRemote
extends AbstractUnitRemote<ColorableLightDataType.ColorableLightData>
implements ColorableLight {
    public ColorableLightRemote() {
        super(ColorableLightDataType.ColorableLightData.class);
    }

    public Future<Void> setColorState(ColorStateType.ColorState colorState) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)colorState, (Remote)this, Void.class);
    }

    public Future<Void> setBrightnessState(BrightnessStateType.BrightnessState value) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)value, (Remote)this, Void.class);
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        try {
            return ((ColorableLightDataType.ColorableLightData)this.getData()).getPowerState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerState", (Throwable)ex);
        }
    }

    public Future<Void> setPowerState(PowerStateType.PowerState powerState) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)powerState, (Remote)this, Void.class);
    }

    public ColorStateType.ColorState getColorState() throws NotAvailableException {
        try {
            return ((ColorableLightDataType.ColorableLightData)this.getData()).getColorState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("ColorState", (Throwable)ex);
        }
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        try {
            return BrightnessStateType.BrightnessState.newBuilder().setBrightness(((ColorableLightDataType.ColorableLightData)this.getData()).getColorState().getColor().getHsbColor().getBrightness()).build();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("BrightnessState", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorableLightDataType.ColorableLightData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorStateType.ColorState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorType.Color.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)HSBColorType.HSBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)RGBColorType.RGBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
    }
}

