/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.BrightnessStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.BrightnessStateOperationService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BrightnessStateType;
import rst.timing.TimestampType;

public class BrightnessStateServiceRemote
extends AbstractServiceRemote<BrightnessStateOperationService, BrightnessStateType.BrightnessState>
implements BrightnessStateOperationServiceCollection {
    public BrightnessStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE);
    }

    public Collection<BrightnessStateOperationService> getBrightnessStateOperationServices() throws CouldNotPerformException {
        return this.getServices();
    }

    @Override
    protected BrightnessStateType.BrightnessState computeServiceState() throws CouldNotPerformException {
        int serviceNumber = this.getBrightnessStateOperationServices().size();
        Double average = 0.0;
        for (BrightnessStateOperationService service : this.getBrightnessStateOperationServices()) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --serviceNumber;
                continue;
            }
            average = average + service.getBrightnessState().getBrightness();
        }
        average = average / (double)serviceNumber;
        return BrightnessStateType.BrightnessState.newBuilder().setBrightness(average.doubleValue()).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        return (BrightnessStateType.BrightnessState)this.getServiceState();
    }
}

