/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.HandleStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.HandleStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.HandleStateType;
import rst.timing.TimestampType;

public class HandleStateServiceRemote
extends AbstractServiceRemote<HandleStateProviderService, HandleStateType.HandleState>
implements HandleStateProviderServiceCollection {
    public HandleStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.HANDLE_STATE_SERVICE);
    }

    public Collection<HandleStateProviderService> getHandleStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected HandleStateType.HandleState computeServiceState() throws CouldNotPerformException {
        int position = 0;
        Collection<HandleStateProviderService> handleStateProviderServices = this.getHandleStateProviderServices();
        int amount = handleStateProviderServices.size();
        for (HandleStateProviderService provider : handleStateProviderServices) {
            if (((UnitRemote)provider).isDataAvailable()) {
                --amount;
                continue;
            }
            position += provider.getHandleState().getPosition();
        }
        return HandleStateType.HandleState.newBuilder().setPosition(position /= amount).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public HandleStateType.HandleState getHandleState() throws NotAvailableException {
        return (HandleStateType.HandleState)this.getServiceState();
    }
}

