/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.PowerConsumptionStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.PowerConsumptionStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.PowerConsumptionStateType;
import rst.timing.TimestampType;

public class PowerConsumptionStateServiceRemote
extends AbstractServiceRemote<PowerConsumptionStateProviderService, PowerConsumptionStateType.PowerConsumptionState>
implements PowerConsumptionStateProviderServiceCollection {
    public PowerConsumptionStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.POWER_CONSUMPTION_STATE_SERVICE);
    }

    public Collection<PowerConsumptionStateProviderService> getPowerConsumptionStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected PowerConsumptionStateType.PowerConsumptionState computeServiceState() throws CouldNotPerformException {
        double consumptionSum = 0.0;
        double averageCurrent = 0.0;
        double averageVoltage = 0.0;
        Collection<PowerConsumptionStateProviderService> powerConsumptionStateProviderServices = this.getPowerConsumptionStateProviderServices();
        int amount = powerConsumptionStateProviderServices.size();
        for (PowerConsumptionStateProviderService provider : powerConsumptionStateProviderServices) {
            if (!((UnitRemote)provider).isDataAvailable()) {
                --amount;
                continue;
            }
            consumptionSum += provider.getPowerConsumptionState().getConsumption();
            averageCurrent += provider.getPowerConsumptionState().getCurrent();
            averageVoltage += provider.getPowerConsumptionState().getVoltage();
        }
        return PowerConsumptionStateType.PowerConsumptionState.newBuilder().setConsumption(consumptionSum).setCurrent(averageCurrent /= (double)amount).setVoltage(averageVoltage /= (double)amount).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public PowerConsumptionStateType.PowerConsumptionState getPowerConsumptionState() throws NotAvailableException {
        return (PowerConsumptionStateType.PowerConsumptionState)this.getServiceState();
    }
}

