/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.PowerStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.PowerStateOperationService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.PowerStateType;
import rst.timing.TimestampType;

public class PowerStateServiceRemote
extends AbstractServiceRemote<PowerStateOperationService, PowerStateType.PowerState>
implements PowerStateOperationServiceCollection {
    public PowerStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE);
    }

    public Collection<PowerStateOperationService> getPowerStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected PowerStateType.PowerState computeServiceState() throws CouldNotPerformException {
        PowerStateType.PowerState.State powerStateValue = PowerStateType.PowerState.State.OFF;
        for (PowerStateOperationService service : this.getPowerStateOperationServices()) {
            if (!((UnitRemote)service).isDataAvailable() || service.getPowerState().getValue() != PowerStateType.PowerState.State.ON) continue;
            powerStateValue = PowerStateType.PowerState.State.ON;
        }
        return PowerStateType.PowerState.newBuilder().setValue(powerStateValue).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        return (PowerStateType.PowerState)this.getServiceState();
    }
}

