/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.SmokeAlarmStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.SmokeAlarmStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.AlarmStateType;
import rst.timing.TimestampType;

public class SmokeAlarmStateServiceRemote
extends AbstractServiceRemote<SmokeAlarmStateProviderService, AlarmStateType.AlarmState>
implements SmokeAlarmStateProviderServiceCollection {
    public SmokeAlarmStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.SMOKE_ALARM_STATE_SERVICE);
    }

    public Collection<SmokeAlarmStateProviderService> getSmokeAlarmStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected AlarmStateType.AlarmState computeServiceState() throws CouldNotPerformException {
        AlarmStateType.AlarmState.State alarmValue = AlarmStateType.AlarmState.State.NO_ALARM;
        for (SmokeAlarmStateProviderService provider : this.getSmokeAlarmStateProviderServices()) {
            if (!((UnitRemote)provider).isDataAvailable() || provider.getSmokeAlarmState().getValue() != AlarmStateType.AlarmState.State.ALARM) continue;
            alarmValue = AlarmStateType.AlarmState.State.ALARM;
        }
        return AlarmStateType.AlarmState.newBuilder().setValue(alarmValue).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public AlarmStateType.AlarmState getSmokeAlarmState() throws NotAvailableException {
        return (AlarmStateType.AlarmState)this.getServiceState();
    }
}

