/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.TamperStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.TamperStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.TamperStateType;
import rst.timing.TimestampType;

public class TamperStateServiceRemote
extends AbstractServiceRemote<TamperStateProviderService, TamperStateType.TamperState>
implements TamperStateProviderServiceCollection {
    public TamperStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.TAMPER_STATE_SERVICE);
    }

    public Collection<TamperStateProviderService> getTamperStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected TamperStateType.TamperState computeServiceState() throws CouldNotPerformException {
        TamperStateType.TamperState.State tamperValue = TamperStateType.TamperState.State.NO_TAMPER;
        long lastDetection = 0L;
        for (TamperStateProviderService provider : this.getTamperStateProviderServices()) {
            if (!((UnitRemote)provider).isDataAvailable()) continue;
            TamperStateType.TamperState tamperState = provider.getTamperState();
            if (tamperState.getValue() == TamperStateType.TamperState.State.TAMPER) {
                tamperValue = TamperStateType.TamperState.State.TAMPER;
            }
            if (tamperState.getLastDetection().getTime() <= lastDetection) continue;
            lastDetection = tamperState.getLastDetection().getTime();
        }
        return TamperStateType.TamperState.newBuilder().setValue(tamperValue).setLastDetection(TimestampType.Timestamp.newBuilder().setTime(lastDetection)).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public TamperStateType.TamperState getTamperState() throws NotAvailableException {
        return (TamperStateType.TamperState)this.getServiceState();
    }
}

