/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.TemperatureStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.TemperatureStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.TemperatureStateType;
import rst.timing.TimestampType;

public class TemperatureStateServiceRemote
extends AbstractServiceRemote<TemperatureStateProviderService, TemperatureStateType.TemperatureState>
implements TemperatureStateProviderServiceCollection {
    public TemperatureStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.TEMPERATURE_STATE_SERVICE);
    }

    public Collection<TemperatureStateProviderService> getTemperatureStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected TemperatureStateType.TemperatureState computeServiceState() throws CouldNotPerformException {
        Double average = 0.0;
        Collection<TemperatureStateProviderService> temperatureStateProviderServices = this.getTemperatureStateProviderServices();
        int amount = temperatureStateProviderServices.size();
        for (TemperatureStateProviderService provider : temperatureStateProviderServices) {
            if (!((UnitRemote)provider).isDataAvailable()) {
                --amount;
                continue;
            }
            average = average + provider.getTemperatureState().getTemperature();
        }
        average = average / (double)amount;
        return TemperatureStateType.TemperatureState.newBuilder().setTemperature(average.doubleValue()).setTimestamp(TimestampType.Timestamp.newBuilder().setTime(System.currentTimeMillis())).build();
    }

    public TemperatureStateType.TemperatureState getTemperatureState() throws NotAvailableException {
        return (TemperatureStateType.TemperatureState)this.getServiceState();
    }
}

