/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import java.util.HashMap;
import java.util.Map;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.bco.registry.device.remote.DeviceRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import rst.domotic.unit.UnitConfigType;

public class UnitRemotePool {
    private Map<Class, Map<String, UnitRemote<?, UnitConfigType.UnitConfig>>> pool;
    private UnitRemoteFactory factory;
    private DeviceRegistryRemote deviceRegistryRemote;

    public UnitRemotePool() throws InstantiationException, InterruptedException {
        this(UnitRemoteFactoryImpl.getInstance());
    }

    public UnitRemotePool(UnitRemoteFactory factory) throws InstantiationException, InterruptedException {
        try {
            this.pool = new HashMap();
            this.factory = factory;
            this.deviceRegistryRemote = new DeviceRegistryRemote();
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            this.deviceRegistryRemote.init();
            this.deviceRegistryRemote.activate();
            this.initAllUnitRemotes();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    private void initAllUnitRemotes() throws CouldNotPerformException, InterruptedException {
        for (UnitConfigType.UnitConfig unitConfig : this.deviceRegistryRemote.getUnitConfigs()) {
            UnitRemote unitRemote = this.factory.newInitializedInstance(unitConfig);
            if (!this.pool.containsKey(unitRemote.getClass())) {
                this.pool.put(unitRemote.getClass(), new HashMap());
            }
            this.pool.get(unitRemote.getClass()).put((String)unitRemote.getId(), unitRemote);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        for (Map<String, UnitRemote<?, UnitConfigType.UnitConfig>> unitCollection : this.pool.values()) {
            for (UnitRemote<?, UnitConfigType.UnitConfig> remote : unitCollection.values()) {
                remote.activate();
            }
        }
    }

    public <R extends AbstractIdentifiableRemote> R getUnitRemote(String unitId, Class<? extends R> remoteClass) {
        return (R)((AbstractIdentifiableRemote)this.pool.get(remoteClass).get(unitId));
    }
}

