/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openbase.bco.dal.remote.unit.LightRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.storage.registry.RemoteControllerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.Scope;
import rst.domotic.unit.UnitConfigType;
import rst.rsb.ScopeType;

public class Units {
    private static final Logger LOGGER = LoggerFactory.getLogger(Units.class);
    public static Units instance;
    private static final ReentrantReadWriteLock unitRemoteRegistryLock;
    private static final UnitRemoteFactory unitRemoteFactory;
    private static RemoteControllerRegistry<String, UnitRemote<? extends GeneratedMessage, UnitConfigType.UnitConfig>> unitRemoteRegistry;
    private static UnitRegistry unitRegistry;

    public static synchronized UnitRegistry getUnitRegistry() throws InterruptedException, CouldNotPerformException {
        if (unitRegistry == null) {
            unitRegistry = CachedUnitRegistryRemote.getRegistry();
            CachedUnitRegistryRemote.waitForData();
        }
        return unitRegistry;
    }

    private static UnitRemote getUnitRemote(String unitId) throws NotAvailableException, InterruptedException {
        unitRemoteRegistryLock.writeLock().lock();
        try {
            UnitRemote unitRemote;
            boolean newInstance;
            try {
                if (!unitRemoteRegistry.contains((Object)unitId)) {
                    newInstance = true;
                    unitRemote = unitRemoteFactory.newInitializedInstance(Units.getUnitRegistry().getUnitConfigById(unitId));
                    unitRemoteRegistry.register((Identifiable)unitRemote);
                } else {
                    newInstance = false;
                    unitRemote = (UnitRemote)unitRemoteRegistry.get((Object)unitId);
                }
            }
            finally {
                unitRemoteRegistryLock.writeLock().unlock();
            }
            if (newInstance) {
                unitRemote.activate();
            }
            return unitRemote;
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("UnitRemote[" + unitId + "]", ex);
        }
    }

    private static UnitRemote getUnitRemote(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException, InterruptedException {
        unitRemoteRegistryLock.writeLock().lock();
        try {
            UnitRemote unitRemote;
            boolean newInstance;
            try {
                if (!unitRemoteRegistry.contains((Object)unitConfig.getId())) {
                    newInstance = true;
                    unitRemote = unitRemoteFactory.newInitializedInstance(unitConfig);
                    unitRemoteRegistry.register((Identifiable)unitRemote);
                } else {
                    newInstance = false;
                    unitRemote = (UnitRemote)unitRemoteRegistry.get((Object)unitConfig.getId());
                }
            }
            finally {
                unitRemoteRegistryLock.writeLock().unlock();
            }
            if (newInstance) {
                unitRemote.activate();
            }
            return unitRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("UnitRemote[" + unitConfig.getId() + "]", (Throwable)ex);
        }
    }

    private static UnitRemote waitForData(UnitRemote unitRemote, boolean waitForData) throws CouldNotPerformException, InterruptedException {
        if (waitForData) {
            unitRemote.waitForData();
        }
        return unitRemote;
    }

    public static UnitRemote getUnit(String unitId, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (unitId == null) {
                assert (false);
                throw new NotAvailableException("UnitId");
            }
            return Units.waitForData(Units.getUnitRemote(unitId), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + unitId + "]", (Throwable)ex);
        }
    }

    public static UnitRemote getUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (unitConfig == null) {
                assert (false);
                throw new NotAvailableException("UnitConfig");
            }
            return Units.waitForData(Units.getUnitRemote(unitConfig), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + unitConfig.getId() + "|" + unitConfig.getLabel() + "]", (Throwable)ex);
        }
    }

    public static <UR extends UnitRemote> UR getUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            return (UR)Units.getUnit(unitConfig, waitForData);
        }
        catch (ClassCastException ex) {
            throw new NotAvailableException("Unit[" + unitConfig.getId() + "]", (Throwable)new InvalidStateException("Requested Unit[" + unitConfig.getLabel() + "] of UnitType[" + unitConfig.getType() + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex));
        }
    }

    public static <UR extends UnitRemote> UR getUnit(String unitId, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            return (UR)Units.getUnit(unitId, waitForData);
        }
        catch (ClassCastException ex) {
            throw new NotAvailableException("Unit[" + unitId + "]", (Throwable)new InvalidStateException("Requested Unit[" + unitId + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex));
        }
    }

    public static UnitRemote getUnitByLabel(String label, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitName");
            }
            List unitConfigList = Units.getUnitRegistry().getUnitConfigsByLabel(label);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("No configuration found in registry!");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit is not unique! Please specify the unit location in order to unique resolve the unit configuration.");
            }
            return Units.getUnit((UnitConfigType.UnitConfig)unitConfigList.get(0), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static UnitRemote getUnitByScope(ScopeType.Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnit(Units.getUnitRegistry().getUnitConfigByScope(scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + ScopeGenerator.generateStringRep((ScopeType.Scope)scope) + "]", (Throwable)ex);
        }
    }

    public static UnitRemote getUnitByScope(Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnitByScope(ScopeTransformer.transform((Scope)scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + scope + "]", (Throwable)ex);
        }
    }

    public static UnitRemote getUnitByScope(String scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnitByScope(ScopeGenerator.generateScope((String)scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + scope + "]", (Throwable)ex);
        }
    }

    public UnitRemote getUnitByLabelAndLocationScope(String label, String locationScope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitLabel");
            }
            if (locationScope == null) {
                assert (false);
                throw new NotAvailableException("UnitLocationScope");
            }
            for (UnitConfigType.UnitConfig unitConfig : Units.getUnitRegistry().getUnitConfigsByLabel(label)) {
                if (!ScopeGenerator.generateStringRep((ScopeType.Scope)Units.getUnitRegistry().getUnitConfigById(unitConfig.getPlacementConfig().getLocationId()).getScope()).equals(locationScope)) continue;
                return Units.getUnit(unitConfig, waitForData);
            }
            throw new InvalidStateException("No unit with Label[" + label + "] found at Location[" + locationScope + "]");
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static LightRemote getLightUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData) throws NotAvailableException, InterruptedException {
        return Units.getUnit(unitConfig, waitForData, LightRemote.class);
    }

    static {
        unitRemoteRegistryLock = new ReentrantReadWriteLock();
        unitRemoteFactory = UnitRemoteFactoryImpl.getInstance();
        try {
            unitRemoteRegistry = new RemoteControllerRegistry();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException((Throwable)new InstantiationException(Units.class, (Throwable)ex)), (Logger)LOGGER);
        }
    }
}

