/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit.unitgroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.unit.unitgroup.UnitGroup;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.service.BlindStateServiceRemote;
import org.openbase.bco.dal.remote.service.BrightnessStateServiceRemote;
import org.openbase.bco.dal.remote.service.ColorStateServiceRemote;
import org.openbase.bco.dal.remote.service.PowerStateServiceRemote;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactory;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactoryImpl;
import org.openbase.bco.dal.remote.service.StandbyStateServiceRemote;
import org.openbase.bco.dal.remote.service.TargetTemperatureStateServiceRemote;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.registry.device.remote.CachedDeviceRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.processing.StringProcessor;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BlindStateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.StandbyStateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.unitgroup.UnitGroupDataType;

public class UnitGroupRemote
extends AbstractUnitRemote<UnitGroupDataType.UnitGroupData>
implements UnitGroup {
    private final Map<ServiceTemplateType.ServiceTemplate, AbstractServiceRemote> serviceRemoteMap = new HashMap<ServiceTemplateType.ServiceTemplate, AbstractServiceRemote>();
    private final ServiceRemoteFactory serviceRemoteFactory = ServiceRemoteFactoryImpl.getInstance();

    public UnitGroupRemote() throws InstantiationException {
        super(UnitGroupDataType.UnitGroupData.class);
    }

    public void init(UnitConfigType.UnitConfig unitGroupUnitConfig) throws InitializationException, InterruptedException {
        try {
            CachedDeviceRegistryRemote.waitForData();
            if (!unitGroupUnitConfig.hasUnitGroupConfig()) {
                throw new VerificationFailedException("Given unit config does not contain a unit group config!");
            }
            if (unitGroupUnitConfig.getUnitGroupConfig().getMemberIdList().isEmpty()) {
                throw new VerificationFailedException("UnitGroupConfig has no unit members!");
            }
            ArrayList<UnitConfigType.UnitConfig> unitConfigs = new ArrayList<UnitConfigType.UnitConfig>();
            for (String unitConfigId : unitGroupUnitConfig.getUnitGroupConfig().getMemberIdList()) {
                unitConfigs.add(CachedDeviceRegistryRemote.getRegistry().getUnitConfigById(unitConfigId));
            }
            if (unitConfigs.isEmpty()) {
                throw new CouldNotPerformException("Could not resolve any unit members!");
            }
            ArrayList<UnitConfigType.UnitConfig> unitConfigsByService = new ArrayList<UnitConfigType.UnitConfig>();
            for (ServiceTemplateType.ServiceTemplate serviceTemplate : unitGroupUnitConfig.getUnitGroupConfig().getServiceTemplateList()) {
                unitConfigs.stream().filter(unitConfig -> this.unitHasService((UnitConfigType.UnitConfig)unitConfig, serviceTemplate)).forEach(unitConfig -> unitConfigsByService.add((UnitConfigType.UnitConfig)unitConfig));
                this.serviceRemoteMap.put(serviceTemplate, this.serviceRemoteFactory.createAndInitServiceRemote(serviceTemplate.getType(), unitConfigsByService));
                unitConfigsByService.clear();
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        try {
            MultiException.ExceptionStack exceptionStack = null;
            for (AbstractServiceRemote remote : this.serviceRemoteMap.values()) {
                try {
                    remote.activate();
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)remote, (Exception)((Object)ex), exceptionStack);
                }
            }
            MultiException.checkAndThrow((String)"Could not activate all internal service remotes!", exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not activate unit group remote!", (Throwable)ex);
        }
    }

    public boolean isActive() {
        return this.serviceRemoteMap.values().stream().noneMatch(remote -> !remote.isActive());
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        for (AbstractServiceRemote remote : this.serviceRemoteMap.values()) {
            remote.deactivate();
        }
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws NotAvailableException, InterruptedException {
        try {
            super.waitForData(timeout, timeUnit);
            for (AbstractServiceRemote remote : this.serviceRemoteMap.values()) {
                remote.waitForData(timeout, timeUnit);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("ServiceData", (Throwable)ex);
        }
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        for (AbstractServiceRemote remote : this.serviceRemoteMap.values()) {
            remote.waitForData();
        }
    }

    public Future<Void> setBrightnessState(BrightnessStateType.BrightnessState brightness) throws CouldNotPerformException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
        this.testServiceAvailability(serviceTemplate);
        return ((BrightnessStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).setBrightnessState(brightness);
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER).build();
        this.testServiceAvailability(serviceTemplate);
        return ((BrightnessStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).getBrightnessState();
    }

    public Future<Void> setColorState(ColorStateType.ColorState color) throws CouldNotPerformException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
        this.testServiceAvailability(serviceTemplate);
        return ((ColorStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).setColorState(color);
    }

    public ColorStateType.ColorState getColorState() throws NotAvailableException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER).build();
        this.testServiceAvailability(serviceTemplate);
        return ((ColorStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).getColorState();
    }

    public Future<Void> setPowerState(PowerStateType.PowerState state) throws CouldNotPerformException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
        this.testServiceAvailability(serviceTemplate);
        return ((PowerStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).setPowerState(state);
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER).build();
        this.testServiceAvailability(serviceTemplate);
        return ((PowerStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).getPowerState();
    }

    public Future<Void> setBlindState(BlindStateType.BlindState state) throws CouldNotPerformException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.BLIND_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
        this.testServiceAvailability(serviceTemplate);
        return ((BlindStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).setBlindState(state);
    }

    public BlindStateType.BlindState getBlindState() throws NotAvailableException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.BLIND_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER).build();
        this.testServiceAvailability(serviceTemplate);
        return ((BlindStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).getBlindState();
    }

    public Future<Void> setStandbyState(StandbyStateType.StandbyState state) throws CouldNotPerformException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.STANDBY_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
        this.testServiceAvailability(serviceTemplate);
        return ((StandbyStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).setStandbyState(state);
    }

    public StandbyStateType.StandbyState getStandbyState() throws NotAvailableException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.STANDBY_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER).build();
        this.testServiceAvailability(serviceTemplate);
        return ((StandbyStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).getStandbyState();
    }

    public Future<Void> setTargetTemperatureState(TemperatureStateType.TemperatureState value) throws CouldNotPerformException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.TARGET_TEMPERATURE_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
        this.testServiceAvailability(serviceTemplate);
        return ((TargetTemperatureStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).setTargetTemperatureState(value);
    }

    public TemperatureStateType.TemperatureState getTargetTemperatureState() throws NotAvailableException {
        ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(ServiceTemplateType.ServiceTemplate.ServiceType.TARGET_TEMPERATURE_STATE_SERVICE).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER).build();
        this.testServiceAvailability(serviceTemplate);
        return ((TargetTemperatureStateServiceRemote)this.serviceRemoteMap.get(serviceTemplate)).getTargetTemperatureState();
    }

    private void testServiceAvailability(ServiceTemplateType.ServiceTemplate serviceTemplate) throws NotAvailableException {
        if (!this.serviceRemoteMap.containsKey(serviceTemplate)) {
            throw new NotAvailableException("groupConfig." + StringProcessor.transformUpperCaseToCamelCase((String)serviceTemplate.toString()));
        }
    }

    private boolean unitHasService(UnitConfigType.UnitConfig unitConfig, ServiceTemplateType.ServiceTemplate serviceTemplate) {
        return unitConfig.getServiceConfigList().stream().anyMatch(serviceConfig -> serviceConfig.getServiceTemplate().getType().equals((Object)serviceTemplate.getType()) && serviceConfig.getServiceTemplate().getPattern().equals((Object)serviceTemplate.getPattern()));
    }
}

