/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit.user;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.user.User;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.pattern.Remote;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.UserActivityStateType;
import rst.domotic.state.UserPresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.user.UserConfigType;
import rst.domotic.unit.user.UserDataType;

public class UserRemote
extends AbstractUnitRemote<UserDataType.UserData>
implements User {
    public UserRemote() {
        super(UserDataType.UserData.class);
    }

    public String getUserName() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getUserConfig().getUserName();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("username", (Throwable)ex);
        }
    }

    public UserActivityStateType.UserActivityState getUserActivityState() throws NotAvailableException {
        try {
            return ((UserDataType.UserData)this.getData()).getUserActivityState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("user activity", (Throwable)ex);
        }
    }

    public UserPresenceStateType.UserPresenceState getUserPresenceState() throws NotAvailableException {
        try {
            return ((UserDataType.UserData)this.getData()).getUserPresenceState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("user presence state", (Throwable)ex);
        }
    }

    public Future<Void> setUserActivityState(UserActivityStateType.UserActivityState UserActivityState2) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)UserActivityState2, (Remote)this, Void.class);
    }

    public Future<Void> setUserPresenceState(UserPresenceStateType.UserPresenceState userPresenceState) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)userPresenceState, (Remote)this, Void.class);
    }

    public Boolean isAtHome() throws NotAvailableException {
        try {
            switch (((UserDataType.UserData)this.getData()).getUserPresenceState().getValue()) {
                case AT_HOME: 
                case SHORT_AT_HOME: 
                case SOON_AWAY: {
                    return true;
                }
                case AWAY: 
                case SHORT_AWAY: 
                case SOON_AT_HOME: {
                    return false;
                }
                case UNKNOWN: {
                    throw new InvalidStateException("UserPresenceState is unknown!");
                }
            }
            throw new AssertionError((Object)("Type " + ((UserDataType.UserData)this.getData()).getUserPresenceState().getValue() + " not supported!"));
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("AtHomeState");
        }
    }

    public String getName() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getUserConfig().getFirstName() + " " + ((UnitConfigType.UnitConfig)this.getConfig()).getUserConfig().getLastName();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Name", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UserDataType.UserData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UserConfigType.UserConfig.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActivationStateType.ActivationState.getDefaultInstance()));
    }
}

