/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.service.collection.PowerStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.PowerStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitTemplateType;

public class PowerStateServiceRemote
extends AbstractServiceRemote<PowerStateOperationService, PowerStateType.PowerState>
implements PowerStateOperationServiceCollection {
    public PowerStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, PowerStateType.PowerState.class);
    }

    public Collection<PowerStateOperationService> getPowerStateOperationServices() {
        return this.getServices();
    }

    public Future<Void> setPowerState(PowerStateType.PowerState powerState) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(input -> input.setPowerState(powerState), super.getServices());
    }

    public Future<Void> setPowerState(PowerStateType.PowerState powerState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(input -> input.setPowerState(powerState), super.getServices(unitType));
    }

    @Override
    protected PowerStateType.PowerState computeServiceState() throws CouldNotPerformException {
        return this.getPowerState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        return (PowerStateType.PowerState)this.getServiceState();
    }

    public PowerStateType.PowerState getPowerState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        PowerStateType.PowerState.State powerStateValue = PowerStateType.PowerState.State.OFF;
        long timestamp = 0L;
        for (PowerStateOperationService service : this.getServices(unitType)) {
            if (!((UnitRemote)service).isDataAvailable()) continue;
            if (service.getPowerState().getValue() == PowerStateType.PowerState.State.ON) {
                powerStateValue = PowerStateType.PowerState.State.ON;
            }
            timestamp = Math.max(timestamp, service.getPowerState().getTimestamp().getTime());
        }
        return ((PowerStateType.PowerState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)PowerStateType.PowerState.newBuilder().setValue(powerStateValue), (Logger)this.logger)).build();
    }
}

