/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactory;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactoryImpl;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.service.ServiceConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;

public abstract class ServiceRemoteManager
implements Activatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRemoteManager.class);
    private boolean active;
    private final SyncObject serviceRemoteMapLock = new SyncObject("ServiceRemoteMapLock");
    private final ServiceRemoteFactory serviceRemoteFactory;
    private final Map<ServiceTemplateType.ServiceTemplate.ServiceType, AbstractServiceRemote> serviceRemoteMap = new HashMap<ServiceTemplateType.ServiceTemplate.ServiceType, AbstractServiceRemote>();
    private final Observer serviceDataObserver;

    public ServiceRemoteManager() {
        this.serviceRemoteFactory = ServiceRemoteFactoryImpl.getInstance();
        this.serviceDataObserver = (source, data) -> this.notifyServiceUpdate(source, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyConfigUpdate(List<String> unitIDList) throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            for (AbstractServiceRemote serviceRemote : this.serviceRemoteMap.values()) {
                serviceRemote.removeDataObserver(this.serviceDataObserver);
                serviceRemote.shutdown();
            }
            this.serviceRemoteMap.clear();
            HashMap serviceMap = new HashMap();
            for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : ServiceTemplateType.ServiceTemplate.ServiceType.values()) {
                serviceMap.put(serviceType, new HashSet());
            }
            for (String unitId : unitIDList) {
                UnitConfigType.UnitConfig unitConfig = Registries.getUnitRegistry().getUnitConfigById(unitId);
                if (!UnitConfigProcessor.isDalUnit((UnitConfigType.UnitConfig)unitConfig)) continue;
                for (ServiceConfigType.ServiceConfig serviceConfig : unitConfig.getServiceConfigList()) {
                    ((Set)serviceMap.get(serviceConfig.getServiceTemplate().getType())).add(unitConfig);
                }
            }
            for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : this.getManagedServiceTypes()) {
                AbstractServiceRemote serviceRemote = this.serviceRemoteFactory.newInitializedInstance(serviceType, (Collection)serviceMap.get(serviceType));
                this.serviceRemoteMap.put(serviceType, serviceRemote);
                if (!this.isActive()) continue;
                serviceRemote.addDataObserver(this.serviceDataObserver);
                serviceRemote.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            this.active = true;
            for (AbstractServiceRemote serviceRemote : this.serviceRemoteMap.values()) {
                serviceRemote.addDataObserver(this.serviceDataObserver);
                serviceRemote.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws InterruptedException, CouldNotPerformException {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            this.active = false;
            for (AbstractServiceRemote serviceRemote : this.serviceRemoteMap.values()) {
                serviceRemote.removeDataObserver(this.serviceDataObserver);
                serviceRemote.deactivate();
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractServiceRemote> getServiceRemoteList() {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            return new ArrayList<AbstractServiceRemote>(this.serviceRemoteMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractServiceRemote getServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            return this.serviceRemoteMap.get(serviceType);
        }
    }

    protected abstract Set<ServiceTemplateType.ServiceTemplate.ServiceType> getManagedServiceTypes() throws NotAvailableException, InterruptedException;

    protected abstract void notifyServiceUpdate(Observable var1, Object var2) throws NotAvailableException, InterruptedException;
}

