/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.Monitor;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.StandbyStateType;
import rst.domotic.unit.dal.MonitorDataType;

public class MonitorRemote
extends AbstractUnitRemote<MonitorDataType.MonitorData>
implements Monitor {
    public MonitorRemote() {
        super(MonitorDataType.MonitorData.class);
    }

    public void notifyDataUpdate(MonitorDataType.MonitorData data) {
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        try {
            return ((MonitorDataType.MonitorData)this.getData()).getPowerState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerState", (Throwable)ex);
        }
    }

    public Future<Void> setPowerState(PowerStateType.PowerState state) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)state, (RSBRemote)this, Void.class);
    }

    public StandbyStateType.StandbyState getStandbyState() throws NotAvailableException {
        try {
            return ((MonitorDataType.MonitorData)this.getData()).getStandbyState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("StandbyState", (Throwable)ex);
        }
    }

    public Future<Void> setStandbyState(StandbyStateType.StandbyState value) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)value, (RSBRemote)this, Void.class);
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)MonitorDataType.MonitorData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)StandbyStateType.StandbyState.getDefaultInstance()));
    }
}

