/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.openbase.bco.dal.remote.unit.BatteryRemote;
import org.openbase.bco.dal.remote.unit.ButtonRemote;
import org.openbase.bco.dal.remote.unit.ColorableLightRemote;
import org.openbase.bco.dal.remote.unit.DimmableLightRemote;
import org.openbase.bco.dal.remote.unit.HandleRemote;
import org.openbase.bco.dal.remote.unit.LightRemote;
import org.openbase.bco.dal.remote.unit.MonitorRemote;
import org.openbase.bco.dal.remote.unit.MotionDetectorRemote;
import org.openbase.bco.dal.remote.unit.PowerConsumptionSensorRemote;
import org.openbase.bco.dal.remote.unit.PowerSwitchRemote;
import org.openbase.bco.dal.remote.unit.ReedContactRemote;
import org.openbase.bco.dal.remote.unit.RollerShutterRemote;
import org.openbase.bco.dal.remote.unit.SmokeDetectorRemote;
import org.openbase.bco.dal.remote.unit.TamperDetectorRemote;
import org.openbase.bco.dal.remote.unit.TemperatureControllerRemote;
import org.openbase.bco.dal.remote.unit.TemperatureSensorRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.bco.dal.remote.unit.agent.AgentRemote;
import org.openbase.bco.dal.remote.unit.app.AppRemote;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.bco.dal.remote.unit.device.DeviceRemote;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.dal.remote.unit.scene.SceneRemote;
import org.openbase.bco.dal.remote.unit.user.UserRemote;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.storage.registry.RemoteControllerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.Scope;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public class Units {
    private static final Logger LOGGER = LoggerFactory.getLogger(Units.class);
    public static final Class<? extends LightRemote> LIGHT = LightRemote.class;
    public static final Class<? extends ColorableLightRemote> LIGHT_COLORABLE = ColorableLightRemote.class;
    public static final Class<? extends DimmableLightRemote> LIGHT_DIMMABLE = DimmableLightRemote.class;
    public static final Class<? extends MotionDetectorRemote> MOTION_DETECTOR = MotionDetectorRemote.class;
    public static final Class<? extends PowerSwitchRemote> POWER_SWITCH = PowerSwitchRemote.class;
    public static final Class<? extends PowerConsumptionSensorRemote> POWER_CONSUMPTION_SENSOR = PowerConsumptionSensorRemote.class;
    public static final Class<? extends ButtonRemote> BUTTON = ButtonRemote.class;
    public static final Class<? extends TemperatureControllerRemote> TEMPERATURE_CONTROLLER = TemperatureControllerRemote.class;
    public static final Class<? extends TemperatureSensorRemote> TEMPERATURE_SENSOR = TemperatureSensorRemote.class;
    public static final Class<? extends BatteryRemote> BATTERY = BatteryRemote.class;
    public static final Class<? extends HandleRemote> HANDLE = HandleRemote.class;
    public static final Class<? extends MonitorRemote> MONITOR = MonitorRemote.class;
    public static final Class<? extends ReedContactRemote> REED_CONTACT = ReedContactRemote.class;
    public static final Class<? extends RollerShutterRemote> ROLLER_SHUTTER = RollerShutterRemote.class;
    public static final Class<? extends SmokeDetectorRemote> SMOKE_DETECTOR = SmokeDetectorRemote.class;
    public static final Class<? extends TamperDetectorRemote> TAMPER_DETECTOR = TamperDetectorRemote.class;
    public static final Class<? extends AgentRemote> UNIT_BASE_AGENT = AgentRemote.class;
    public static final Class<? extends AppRemote> UNIT_BASE_APP = AppRemote.class;
    public static final Class<? extends SceneRemote> UNIT_BASE_SCENE = SceneRemote.class;
    public static final Class<? extends UserRemote> UNIT_BASE_USER = UserRemote.class;
    public static final Class<? extends DeviceRemote> UNIT_BASE_DEVICE = DeviceRemote.class;
    public static final Class<? extends LocationRemote> UNIT_BASE_LOCATION = LocationRemote.class;
    public static final Class<? extends ConnectionRemote> UNIT_BASE_CONNECTION_DOOR = ConnectionRemote.class;
    public static final Class<? extends ConnectionRemote> UNIT_BASE_CONNECTION_WINDOW = ConnectionRemote.class;
    public static final Class<? extends ConnectionRemote> UNIT_BASE_CONNECTION_PASSAGE = ConnectionRemote.class;
    public static final Class<? extends ConnectionRemote> BASE_UNIT_CONNECTION = ConnectionRemote.class;
    public static Units instance;
    private static final ReentrantReadWriteLock unitRemoteRegistryLock;
    private static final UnitRemoteFactory unitRemoteFactory;
    private static RemoteControllerRegistry<String, org.openbase.bco.dal.lib.layer.unit.UnitRemote<? extends GeneratedMessage>> unitRemoteRegistry;
    private static UnitRegistry unitRegistry;
    public static final SyncObject UNIT_POOL_LOCK;

    public static synchronized UnitRegistry getUnitRegistry() throws InterruptedException, CouldNotPerformException {
        if (unitRegistry == null) {
            unitRegistry = CachedUnitRegistryRemote.getRegistry();
            CachedUnitRegistryRemote.waitForData();
        }
        return unitRegistry;
    }

    private static org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnitRemote(String unitId) throws NotAvailableException, InterruptedException {
        try {
            org.openbase.bco.dal.lib.layer.unit.UnitRemote unitRemote;
            boolean newInstance;
            unitRemoteRegistryLock.writeLock().lock();
            try {
                if (!unitRemoteRegistry.contains((Object)unitId)) {
                    newInstance = true;
                    unitRemote = unitRemoteFactory.newInitializedInstance(Units.getUnitRegistry().getUnitConfigById(unitId));
                    unitRemoteRegistry.register((Identifiable)unitRemote);
                } else {
                    newInstance = false;
                    unitRemote = (org.openbase.bco.dal.lib.layer.unit.UnitRemote)unitRemoteRegistry.get((Object)unitId);
                }
            }
            finally {
                unitRemoteRegistryLock.writeLock().unlock();
            }
            if (newInstance && unitRemote.isEnabled()) {
                unitRemote.activate();
                unitRemote.lock(unitRemoteRegistry);
            }
            return unitRemote;
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("UnitRemote[" + unitId + "]", ex);
        }
    }

    private static org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnitRemote(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException, InterruptedException {
        try {
            UnitRemote unitRemote;
            boolean newInstance;
            unitRemoteRegistryLock.writeLock().lock();
            try {
                if (!unitRemoteRegistry.contains((Object)unitConfig.getId())) {
                    newInstance = true;
                    unitRemote = unitRemoteFactory.newInitializedInstance(unitConfig);
                    unitRemoteRegistry.register((Identifiable)unitRemote);
                } else {
                    newInstance = false;
                    unitRemote = (org.openbase.bco.dal.lib.layer.unit.UnitRemote)unitRemoteRegistry.get((Object)unitConfig.getId());
                }
            }
            finally {
                unitRemoteRegistryLock.writeLock().unlock();
            }
            if (newInstance && unitRemote.isEnabled()) {
                unitRemote.activate();
                unitRemote.lock(unitRemoteRegistry);
            }
            return unitRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("UnitRemote[" + unitConfig.getId() + "]", (Throwable)ex);
        }
    }

    private static org.openbase.bco.dal.lib.layer.unit.UnitRemote waitForData(org.openbase.bco.dal.lib.layer.unit.UnitRemote unitRemote, boolean waitForData) throws CouldNotPerformException, InterruptedException {
        if (waitForData) {
            unitRemote.waitForData();
        }
        return unitRemote;
    }

    public static org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnit(String unitId, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (unitId == null) {
                assert (false);
                throw new NotAvailableException("UnitId");
            }
            return Units.waitForData(Units.getUnitRemote(unitId), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + unitId + "]", (Throwable)ex);
        }
    }

    public static org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (unitConfig == null) {
                assert (false);
                throw new NotAvailableException("UnitConfig");
            }
            return Units.waitForData(Units.getUnitRemote(unitConfig), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + unitConfig.getId() + "|" + unitConfig.getLabel() + "]", (Throwable)ex);
        }
    }

    public static <UR extends org.openbase.bco.dal.lib.layer.unit.UnitRemote> UR getUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            return (UR)Units.getUnit(unitConfig, waitForData);
        }
        catch (ClassCastException ex) {
            throw new NotAvailableException("Unit[" + unitConfig.getId() + "]", (Throwable)new InvalidStateException("Requested Unit[" + unitConfig.getLabel() + "] of UnitType[" + unitConfig.getType() + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex));
        }
    }

    public static <UR extends org.openbase.bco.dal.lib.layer.unit.UnitRemote<?>> UR getUnit(String unitId, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            return (UR)Units.getUnit(unitId, waitForData);
        }
        catch (ClassCastException ex) {
            throw new NotAvailableException("Unit[" + unitId + "]", (Throwable)new InvalidStateException("Requested Unit[" + unitId + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex));
        }
    }

    public static org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnitByLabelAndType(String label, UnitTemplateType.UnitTemplate.UnitType unitType, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitName");
            }
            List unitConfigList = Units.getUnitRegistry().getUnitConfigsByLabelAndUnitType(label, unitType);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("No configuration found in registry!");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit is not unique! Please specify the unit location in order to unique resolve the unit configuration.");
            }
            return Units.getUnit((UnitConfigType.UnitConfig)unitConfigList.get(0), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnitByLabel(String label, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitName");
            }
            List unitConfigList = Units.getUnitRegistry().getUnitConfigsByLabel(label);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("No configuration found in registry!");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit is not unique! Please specify the unit location in order to unique resolve the unit configuration.");
            }
            return Units.getUnit((UnitConfigType.UnitConfig)unitConfigList.get(0), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static <UR extends org.openbase.bco.dal.lib.layer.unit.UnitRemote<?>> UR getUnitByLabel(String label, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            try {
                return (UR)Units.getUnitByLabelAndType(label, Units.getUnitTypeByRemoteClass(unitRemoteClass), waitForData);
            }
            catch (ClassCastException ex) {
                throw new InvalidStateException("Requested Unit[" + label + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static UnitTemplateType.UnitTemplate.UnitType getUnitTypeByRemoteClass(Class<? extends org.openbase.bco.dal.lib.layer.unit.UnitRemote<?>> unitRemoteClass) throws CouldNotPerformException {
        try {
            return UnitTemplateType.UnitTemplate.UnitType.valueOf((String)StringProcessor.transformToUpperCase((String)unitRemoteClass.getSimpleName().replaceAll("Remote", "")));
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw new CouldNotPerformException("Could not resolve unit type out of UnitRemoteClass[" + unitRemoteClass.getName() + "]", (Throwable)ex);
        }
    }

    public static org.openbase.bco.dal.lib.layer.unit.UnitRemote<?> getUnitByScope(ScopeType.Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnit(Units.getUnitRegistry().getUnitConfigByScope(scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            try {
                throw new NotAvailableException("Unit[" + ScopeGenerator.generateStringRep((ScopeType.Scope)scope) + "]", (Throwable)ex);
            }
            catch (CouldNotPerformException ex1) {
                throw new NotAvailableException("Unit[?]", (Throwable)ex);
            }
        }
    }

    public static org.openbase.bco.dal.lib.layer.unit.UnitRemote<?> getUnitByScope(Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnitByScope(ScopeTransformer.transform((Scope)scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + scope + "]", (Throwable)ex);
        }
    }

    public static org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnitByScope(String scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnitByScope(ScopeGenerator.generateScope((String)scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + scope + "]", (Throwable)ex);
        }
    }

    public org.openbase.bco.dal.lib.layer.unit.UnitRemote getUnitByLabelAndLocationScope(String label, String locationScope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitLabel");
            }
            if (locationScope == null) {
                assert (false);
                throw new NotAvailableException("UnitLocationScope");
            }
            for (UnitConfigType.UnitConfig unitConfig : Units.getUnitRegistry().getUnitConfigsByLabel(label)) {
                if (!ScopeGenerator.generateStringRep((ScopeType.Scope)Units.getUnitRegistry().getUnitConfigById(unitConfig.getPlacementConfig().getLocationId()).getScope()).equals(locationScope)) continue;
                return Units.getUnit(unitConfig, waitForData);
            }
            throw new InvalidStateException("No unit with Label[" + label + "] found at Location[" + locationScope + "]");
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static boolean contains(org.openbase.bco.dal.lib.layer.unit.UnitRemote<? extends GeneratedMessage> unitRemote) throws CouldNotPerformException {
        return unitRemoteRegistry.contains(unitRemote);
    }

    static {
        unitRemoteRegistryLock = new ReentrantReadWriteLock();
        unitRemoteFactory = UnitRemoteFactoryImpl.getInstance();
        UNIT_POOL_LOCK = new SyncObject("UnitPoolLock");
        try {
            unitRemoteRegistry = new RemoteControllerRegistry();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException(Units.class, (Throwable)new InstantiationException(Units.class, (Throwable)ex)), (Logger)LOGGER);
        }
        Shutdownable.registerShutdownHook((Shutdownable)new Shutdownable(){

            public void shutdown() {
                try {
                    ((Stream)unitRemoteRegistry.getEntries().stream().parallel()).forEach(unitRemote -> {
                        try {
                            LOGGER.info("SHUTTING_DOWN remote " + unitRemote.getLabel() + " - " + Thread.currentThread().getName() + " UNLOCK");
                            unitRemote.unlock((Object)unitRemoteRegistry);
                            LOGGER.info("SHUTTING_DOWN remote " + unitRemote.getLabel() + " - " + Thread.currentThread().getName() + " SHUTDOWN");
                            unitRemote.shutdown();
                            LOGGER.info("SHUTTING_DOWN remote " + unitRemote.getLabel() + " - " + Thread.currentThread().getName() + " DONE!");
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((String)("Could not properly shutdown " + unitRemote), (Throwable)ex, (Logger)LOGGER);
                        }
                    });
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((String)"Could not properly shutdown remote pool!", (Throwable)ex, (Logger)LOGGER);
                }
                finally {
                    unitRemoteRegistry.shutdown();
                }
            }

            public String toString() {
                return "UnitRemotePool";
            }
        });
    }
}

