/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.awt.Color;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.service.collection.ColorStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.ColorStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.lib.transform.HSBColorToRGBColorTransformer;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.TypeNotSupportedException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.unit.UnitTemplateType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;

public class ColorStateServiceRemote
extends AbstractServiceRemote<ColorStateOperationService, ColorStateType.ColorState>
implements ColorStateOperationServiceCollection {
    public ColorStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE, ColorStateType.ColorState.class);
    }

    public Collection<ColorStateOperationService> getColorStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected ColorStateType.ColorState computeServiceState() throws CouldNotPerformException {
        return this.getColorState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public Future<Void> setColorState(ColorStateType.ColorState colorState) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(input -> input.setColorState(colorState), this.getServices());
    }

    public Future<Void> setColorState(ColorStateType.ColorState colorState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(input -> input.setColorState(colorState), this.getServices(unitType));
    }

    public ColorStateType.ColorState getColorState() throws NotAvailableException {
        return (ColorStateType.ColorState)this.getServiceState();
    }

    public ColorStateType.ColorState getColorState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        try {
            double averageRed = 0.0;
            double averageGreen = 0.0;
            double averageBlue = 0.0;
            int amount = this.getColorStateOperationServices().size();
            long timestamp = 0L;
            Collection colorStateOperationServicCollection = this.getServices(unitType);
            for (ColorStateOperationService service : colorStateOperationServicCollection) {
                if (!((UnitRemote)service).isDataAvailable()) {
                    --amount;
                    continue;
                }
                Color color = HSBColorToRGBColorTransformer.transform((HSBColorType.HSBColor)service.getColorState().getColor().getHsbColor());
                averageRed += (double)color.getRed();
                averageGreen += (double)color.getGreen();
                averageBlue += (double)color.getBlue();
                timestamp = Math.max(timestamp, service.getColorState().getTimestamp().getTime());
            }
            HSBColorType.HSBColor hsbColor = HSBColorToRGBColorTransformer.transform((Color)new Color((int)(averageRed /= (double)amount), (int)(averageGreen /= (double)amount), (int)(averageBlue /= (double)amount)));
            return ((ColorStateType.ColorState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)ColorStateType.ColorState.newBuilder().setColor(ColorType.Color.newBuilder().setType(ColorType.Color.Type.HSB).setHsbColor(hsbColor)), (Logger)this.logger)).build();
        }
        catch (CouldNotTransformException | TypeNotSupportedException ex) {
            throw new NotAvailableException("Could not transform from HSB to RGB or vice-versa!", ex);
        }
    }
}

