/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.bco.registry.unit.remote.UnitRegistryRemote;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.processing.GenericMessageProcessor;
import org.openbase.jul.extension.protobuf.processing.MessageProcessor;
import org.openbase.jul.extension.rsb.com.AbstractConfigurableRemote;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.extension.rst.iface.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.Scope;
import rst.domotic.action.ActionConfigType;
import rst.domotic.action.SnapshotType;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public abstract class AbstractUnitRemote<M extends GeneratedMessage>
extends AbstractConfigurableRemote<M, UnitConfigType.UnitConfig>
implements UnitRemote<M> {
    private UnitTemplateType.UnitTemplate template;
    private UnitRegistry unitRegistry;

    public AbstractUnitRemote(Class<M> dataClass) {
        super(dataClass, UnitConfigType.UnitConfig.class);
    }

    protected UnitRegistry getUnitRegistry() throws InterruptedException, CouldNotPerformException {
        if (this.unitRegistry == null) {
            this.unitRegistry = Registries.getUnitRegistry();
            Registries.getUnitRegistry().waitForData();
        }
        return this.unitRegistry;
    }

    public void initById(String id) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getUnitRegistry().getUnitConfigById(id));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void initByLabel(String label) throws InitializationException, InterruptedException {
        try {
            List unitConfigList = this.getUnitRegistry().getUnitConfigsByLabel(label);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("Unit with Label[" + label + "]");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit with Label[" + label + "] is not unique!");
            }
            this.init((GeneratedMessage)unitConfigList.get(0));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(ScopeType.Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getUnitRegistry().getUnitConfigByScope(scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeTransformer.transform((Scope)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(String scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(String label, ScopeProvider location) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)label, (String)this.getDataClass().getSimpleName(), (ScopeType.Scope)location.getScope()));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        this.setMessageProcessor((MessageProcessor)new GenericMessageProcessor(this.getDataClass()));
        ((UnitRegistryRemote)this.unitRegistry).addDataObserver((source, data) -> {
            try {
                UnitConfigType.UnitConfig newUnitConfig = this.unitRegistry.getUnitConfigById(this.getId());
                if (!newUnitConfig.equals((Object)this.getConfig())) {
                    this.applyConfigUpdate(newUnitConfig);
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)("Could not update unit config of " + this), (Throwable)ex, (Logger)this.logger);
            }
        });
    }

    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        if (config == null) {
            throw new NotAvailableException("UnitConfig");
        }
        try {
            if (((UnitConfigType.UnitConfig)this.getConfig()).equals((Object)config)) {
                this.logger.debug("Skip config update because no config change detected!");
                return config;
            }
        }
        catch (NotAvailableException notAvailableException) {
            // empty catch block
        }
        this.template = this.getUnitRegistry().getUnitTemplateByType(config.getType());
        return (UnitConfigType.UnitConfig)super.applyConfigUpdate((GeneratedMessage)config);
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        if (!this.isEnabled()) {
            throw new InvalidStateException("The activation of an remote is not allowed if the referred unit is disabled!");
        }
        if (!Units.contains(this)) {
            this.logger.warn("You are using a unit remote which is not maintained by the global unit remote pool! This is extremely inefficient! Please use \"Units.getUnit(...)\" instead creating your own instances!");
        }
        super.activate();
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        this.verifyEnablingState();
        super.waitForData();
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        this.verifyEnablingState();
        super.waitForData(timeout, timeUnit);
    }

    public boolean isEnabled() {
        try {
            assert (this.getConfig() instanceof UnitConfigType.UnitConfig);
            return ((UnitConfigType.UnitConfig)this.getConfig()).getEnablingState().getValue().equals((Object)EnablingStateType.EnablingState.State.ENABLED);
        }
        catch (CouldNotPerformException ex) {
            LoggerFactory.getLogger(org.openbase.bco.dal.lib.layer.unit.UnitRemote.class).warn("isEnabled() was called on non initialized unit!");
            assert (false);
            return false;
        }
    }

    private void verifyEnablingState() throws FatalImplementationErrorException {
        if (!this.isEnabled()) {
            if (JPService.testMode()) {
                throw new FatalImplementationErrorException("Waiting for data of a disabled unit should be avoided!", (Object)"Calling instance");
            }
            this.logger.warn("Waiting for data of an disabled unit should be avoided! Probably this method will block forever!");
        }
    }

    public UnitTemplateType.UnitTemplate.UnitType getType() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getType();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit type", ex);
        }
    }

    public UnitTemplateType.UnitTemplate getTemplate() throws NotAvailableException {
        if (this.template == null) {
            throw new NotAvailableException("UnitTemplate");
        }
        return this.template;
    }

    public String getLabel() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getLabel();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public ScopeType.Scope getScope() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getScope();
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public UnitConfigType.UnitConfig getLocationConfig() throws NotAvailableException {
        try {
            return this.unitRegistry.getUnitConfigById(((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId());
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("LocationConfig", (Throwable)ex);
        }
    }

    public Future<Void> applyAction(ActionConfigType.ActionConfig actionConfig) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)actionConfig, (RSBRemote)this, Void.class);
    }

    public Future<SnapshotType.Snapshot> recordSnapshot() throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((RSBRemote)this, SnapshotType.Snapshot.class);
    }
}

