/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.service.collection.BrightnessStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.BrightnessStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.unit.UnitTemplateType;

public class BrightnessStateServiceRemote
extends AbstractServiceRemote<BrightnessStateOperationService, BrightnessStateType.BrightnessState>
implements BrightnessStateOperationServiceCollection {
    public BrightnessStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE, BrightnessStateType.BrightnessState.class);
    }

    public Collection<BrightnessStateOperationService> getBrightnessStateOperationServices() throws CouldNotPerformException {
        return this.getServices();
    }

    public Future<Void> setBrightnessState(BrightnessStateType.BrightnessState brightnessState) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(this.getServices(), input -> input.setBrightnessState(brightnessState));
    }

    public Future<Void> setBrightnessState(BrightnessStateType.BrightnessState brightnessState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(this.getServices(unitType), input -> input.setBrightnessState(brightnessState));
    }

    @Override
    protected BrightnessStateType.BrightnessState computeServiceState() throws CouldNotPerformException {
        return this.getBrightnessState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        return (BrightnessStateType.BrightnessState)this.getData();
    }

    public BrightnessStateType.BrightnessState getBrightnessState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        Collection brightnessStateOperationServices = this.getServices(unitType);
        int serviceNumber = brightnessStateOperationServices.size();
        Double average = 0.0;
        long timestamp = 0L;
        for (BrightnessStateOperationService service : brightnessStateOperationServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --serviceNumber;
                continue;
            }
            average = average + service.getBrightnessState().getBrightness();
            timestamp = Math.max(timestamp, service.getBrightnessState().getTimestamp().getTime());
        }
        average = average / (double)serviceNumber;
        return ((BrightnessStateType.BrightnessState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)BrightnessStateType.BrightnessState.newBuilder().setBrightness(average.doubleValue()), (Logger)this.logger)).build();
    }
}

