/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.Dimmer;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.DimmerDataType;

public class DimmerRemote
extends AbstractUnitRemote<DimmerDataType.DimmerData>
implements Dimmer {
    public DimmerRemote() {
        super(DimmerDataType.DimmerData.class);
    }

    public Future<Void> setPowerState(PowerStateType.PowerState powerState) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)powerState, (RSBRemote)this, Void.class);
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        try {
            return ((DimmerDataType.DimmerData)this.getData()).getPowerState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerState", (Throwable)ex);
        }
    }

    public Future<Void> setBrightnessState(BrightnessStateType.BrightnessState brightnessState) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)brightnessState, (RSBRemote)this, Void.class);
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        try {
            return ((DimmerDataType.DimmerData)this.getData()).getBrightnessState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("BrightnessState", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)DimmerDataType.DimmerData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
    }
}

