/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.collection.ContactStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.ContactStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ContactStateType;
import rst.domotic.unit.UnitTemplateType;

public class ContactStateServiceRemote
extends AbstractServiceRemote<ContactStateProviderService, ContactStateType.ContactState>
implements ContactStateProviderServiceCollection {
    public ContactStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.CONTACT_STATE_SERVICE, ContactStateType.ContactState.class);
    }

    @Deprecated
    public Collection<ContactStateProviderService> getContactStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected ContactStateType.ContactState computeServiceState() throws CouldNotPerformException {
        return this.getContactState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public ContactStateType.ContactState getContactState() throws NotAvailableException {
        return (ContactStateType.ContactState)this.getServiceState();
    }

    public ContactStateType.ContactState getContactState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        ContactStateType.ContactState.State contactValue = ContactStateType.ContactState.State.CLOSED;
        long timestamp = 0L;
        for (ContactStateProviderService service : this.getServices(unitType)) {
            if (!((UnitRemote)service).isDataAvailable()) continue;
            if (service.getContactState().getValue() == ContactStateType.ContactState.State.OPEN) {
                contactValue = ContactStateType.ContactState.State.OPEN;
            }
            timestamp = Math.max(timestamp, service.getContactState().getTimestamp().getTime());
        }
        return ((ContactStateType.ContactState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)ContactStateType.ContactState.newBuilder().setValue(contactValue), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

